/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/******************* Murata Manufacturing Co.,Ltd. 2014 *****************
 *
 * Filename:   Socket.cpp
 *
 * Purpose:    This module has implementation of socket.
 *              
 * $Author: kishino $
 *
 * $Date: 2014/03/26 $
 *
 * $Revision: 0.0.0.1 $
 * ***********************************************************************/
#include "Socket.h"
#include <cstring>

using namespace murata_wifi;

Socket::Socket()
{
    mSocketID = -1;
}

Socket::~Socket() {
//    close(); //Don't want to leak
}

int Socket::set_option(int level, int optname, const void *optval, socklen_t optlen) {
    return 0;
}

int Socket::get_option(int level, int optname, void *optval, socklen_t *optlen) {
    return 0;
}

int Socket::close(bool shutdown)
{
    
    return 0;
}

#if 0
int Socket::select(struct timeval *timeout, bool read, bool write)
{
    return 0;
}
#endif

int Socket::createSocket( unsigned char bind, unsigned int local_addr, unsigned short port )
{
    C_SNIC_Core               *snic_core_p  = C_SNIC_Core::getInstance();
    C_SNIC_UartCommandManager *uartCmdMgr_p = snic_core_p->getUartCommand();
    // Get buffer for response payload from MemoryPool
    C_SNIC_Core::tagMEMPOOL_BLOCK_T *payload_buf = snic_core_p->allocCmdBuf();
    if( payload_buf == NULL )
    {
        printf("createSocket payload_buf NULL\r\n");
        return -1;
    }

    C_SNIC_Core::tagSNIC_TCP_CREATE_SOCKET_REQ_T req;
    int req_len = 0;
    
    // Make request
    req.cmd_sid  = UART_CMD_SID_SNIC_TCP_CREATE_SOCKET_REQ;
    req_len++;
    req.seq      = mUartRequestSeq++;
    req_len++;
    req.bind     = bind;
    req_len++;
    if( bind != 0 )
    {
/*
        req.local_addr = local_addr;
        req_len++;
        req.local_port = port;
        req_len++;
*/
    }

    unsigned char command_array[UART_REQUEST_PAYLOAD_MAX];
    unsigned int  command_len;
    // Preparation of command
    command_len = snic_core_p->preparationSendCommand( UART_CMD_ID_SNIC, req.cmd_sid, (unsigned char *)&req
                            , req_len, payload_buf->buf, command_array );

    // Send uart command request
    snic_core_p->sendUart( command_len, command_array );

    int ret;
    // Wait UART response
    ret = uartCmdMgr_p->wait();
    if( ret != 0 )
    {
        printf( "createSocket failed\r\n" );
        snic_core_p->freeCmdBuf( payload_buf );
        return -1;
    }
    
    if( uartCmdMgr_p->getCommandStatus() != 0 )
    {
        printf("createSocket status:%02x\r\n", uartCmdMgr_p->getCommandStatus());
        snic_core_p->freeCmdBuf( payload_buf );
        return -1;
    }
    mSocketID = payload_buf->buf[3];
    snic_core_p->freeCmdBuf( payload_buf );

    return 0;
}
