#ifndef _YD_WIFI_UART_MSG_H_
#define _YD_WIFI_UART_MSG_H_

#include "mbed.h"
#include "rtos.h"
#include "RawSerial.h"

#define UART_CMD_SOM        0x02
#define UART_CMD_EOM        0x04
#define UART_CMD_ESC        0x10

/* SNIC UART Command ID */
#define UART_CMD_ID_GEN     0x01    //General command
#define UART_CMD_ID_WIFI    0x50    //Wi-Fi command

/* SNIC UART Subcommand ID */
#define UART_CMD_SID_GEN_PWR_UP_IND          0x00   //Power up indication
#define UART_CMD_SID_GEN_FW_VER_GET_REQ      0x08   //Get firmware version string

#define UART_CMD_SID_WIFI_ON_REQ             0x00   // Turn on Wifi
#define UART_CMD_SID_WIFI_OFF_REQ            0x01   // Turn off Wifi
#define UART_CMD_SID_WIFI_JOIN_REQ           0x02   // Associate to a network
#define UART_CMD_SID_WIFI_DISCONNECT_REQ     0x03   // Disconnect from a network
#define UART_CMD_SID_WIFI_GET_STATUS_REQ     0x04   // Get WiFi status
#define UART_CMD_SID_WIFI_SCAN_REQ           0x05   // Scan WiFi networks
#define UART_CMD_SID_WIFI_GET_STA_RSSI_REQ   0x06   // Get STA signal strength (RSSI)
#define UART_CMD_SID_WIFI_AP_CTRL_REQ        0x07   // Soft AP on-off control
#define UART_CMD_SID_WIFI_WPS_REQ            0x08   // Start WPS process
#define UART_CMD_SID_WIFI_AP_GET_CLIENT_REQ  0x0A   // Get clients that are associated to the soft AP.
#define UART_CMD_SID_WIFI_NETWORK_STATUS_IND 0x10   // Network status indication
#define UART_CMD_SID_WIFI_SCAN_RESULT_IND    0x11   // Scan result indication

/* SNIC UART Command response status code */
#define UART_CMD_RES_SNIC_SUCCESS                   0x00
#define UART_CMD_RES_SNIC_FAIL                      0x01
#define UART_CMD_RES_SNIC_INIT_FAIL                 0x02
#define UART_CMD_RES_SNIC_CLEANUP_FAIL              0x03
#define UART_CMD_RES_SNIC_GETADDRINFO_FAIL          0x04
#define UART_CMD_RES_SNIC_CREATE_SOCKET_FAIL        0x05
#define UART_CMD_RES_SNIC_BIND_SOCKET_FAIL          0x06
#define UART_CMD_RES_SNIC_LISTEN_SOCKET_FAIL        0x07
#define UART_CMD_RES_SNIC_ACCEPT_SOCKET_FAIL        0x08
#define UART_CMD_RES_SNIC_PARTIAL_CLOSE_FAIL        0x09
#define UART_CMD_RES_SNIC_SOCKET_PARTIALLY_CLOSED   0x0A
#define UART_CMD_RES_SNIC_SOCKET_CLOSED             0x0B
#define UART_CMD_RES_SNIC_CLOSE_SOCKET_FAIL         0x0C
#define UART_CMD_RES_SNIC_PACKET_TOO_LARGE          0x0D
#define UART_CMD_RES_SNIC_SEND_FAIL                 0x0E
#define UART_CMD_RES_SNIC_CONNECT_TO_SERVER_FAIL    0x0F
#define UART_CMD_RES_SNIC_NOT_ENOUGH_MEMORY         0x10
#define UART_CMD_RES_SNIC_TIMEOUT                   0x11
#define UART_CMD_RES_SNIC_CONNECTION_UP             0x12
#define UART_CMD_RES_SNIC_GETSOCKOPT_FAIL           0x13
#define UART_CMD_RES_SNIC_SETSOCKOPT_FAIL           0x14
#define UART_CMD_RES_SNIC_INVALID_ARGUMENT          0x15
#define UART_CMD_RES_SNIC_SEND_ARP_FAIL             0x16
#define UART_CMD_RES_SNIC_INVALID_SOCKET            0x17
#define UART_CMD_RES_SNIC_COMMAND_PENDING           0x18
#define UART_CMD_RES_SNIC_SOCKET_NOT_BOUND          0x19
#define UART_CMD_RES_SNIC_SOCKET_NOT_CONNECTED      0x1A
#define UART_CMD_RES_SNIC_NO_NETWORK                0x20
#define UART_CMD_RES_SNIC_INIT_NOT_DONE             0x21
#define UART_CMD_RES_SNIC_NET_IF_FAIL               0x22
#define UART_CMD_RES_SNIC_NET_IF_NOT_UP             0x23
#define UART_CMD_RES_SNIC_DHCP_START_FAIL           0x24

#define UART_CMD_RES_WIFI_SUCCESS               0x00
#define UART_CMD_RES_WIFI_ERR_UNKNOWN_COUNTRY   0x01
#define UART_CMD_RES_WIFI_ERR_INIT_FAIL         0x02
#define UART_CMD_RES_WIFI_ERR_ALREADY_JOINED    0x03
#define UART_CMD_RES_WIFI_ERR_AUTH_TYPE         0x04
#define UART_CMD_RES_WIFI_ERR_JOIN_FAIL         0x05
#define UART_CMD_RES_WIFI_ERR_NOT_JOINED        0x06
#define UART_CMD_RES_WIFI_ERR_LEAVE_FAILED      0x07
#define UART_CMD_RES_WIFI_COMMAND_PENDING       0x08
#define UART_CMD_RES_WIFI_WPS_NO_CONFIG         0x09
#define UART_CMD_RES_WIFI_NETWORK_UP            0x10
#define UART_CMD_RES_WIFI_NETWORK_DOWN          0x11
#define UART_CMD_RES_WIFI_FAIL                  0xFF

/** UART Command sequence number
*/
static unsigned char mUartRequestSeq;  

/** C_YD_UartMsg class
 */
class C_YD_UartMsg
{

public:
    C_YD_UartMsg();
    
    /** Make SNIC UART command payload.
            @param cmd_len      Command length
            @param cmd_p        Command pointer
            @param payload_p    Payload pointer[output]
            @return payload length    
    */
    static unsigned short makePayload( unsigned int cmd_len, unsigned char *cmd_p, unsigned char *payload_p );
    
    /** Make SNIC UART command.
            @param cmd_id         Command ID
            @param payload_p      Payload pointer
            @param uart_command_p UART Command pointer [output]
            @return UART Command length    
    */
    static unsigned int makeRequest( unsigned char cmd_id, unsigned char *payload_p, unsigned short payload_len, unsigned char *uart_command_p );


    /** Get uart command from receive data.
            @param recvdata_len   Receive data length
            @param recvdata_p     Pointer of received data from UART
            @param command_id_p   Pointer of command ID[output]
            @param payload_p      Pointer of payload[output]
            @return Payload length    
    */
    static unsigned int getResponsePayload( unsigned int recvdata_len, unsigned char *recvdata_p
                                    , unsigned char *command_id_p,  unsigned char *payload_p );
protected:

};
#endif /* _YD_WIFI_UART_MSG_H_ */