#include "mbed.h"
#include "YDwifi.h"
#include "YDwifi_uartmsg.h"
#include <string>
//#include <algorithm>

C_YDwifi *C_YDwifi::mInstance_p;

C_YDwifi::C_YDwifi(PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud):
    mUart(tx, rx), mModuleReset(reset)
{
    mUartRecvThread_p = NULL;
    mInstance_p       = this;
    mUartRequestSeq   = 0;

    printf("baud:%d\r\n", baud);
    mUart.baud( baud );
}

int C_YDwifi::initUart()
{
    // Create UART recv thread
    mUartRecvThread_p = new Thread( C_YDwifi::uartRecvThread );
    if( mUartRecvThread_p == NULL )
    {
        printf("[C_YDwifi::initUart] thread cread failed\r\n");
        return -1;
    }
    
    // set intr callback function
    mUart.attach( this, &C_YDwifi::uartIntr_callback, Serial::RxIrq );
    
    return 0;
}

void C_YDwifi::uartIntr_callback( void )
{
#if 0
    C_YDwifi *instance = C_YDwifi::getInstance();
    instance->mUart.putc('G');
    instance->mUartRecvThread_p->signal_set(1);
#else
    mUart.putc('G');
    mUartRecvThread_p->signal_set(1);
#endif
}

void C_YDwifi::uartRecvThread (void const *args_p) {
    C_YDwifi *instance_p = C_YDwifi::getInstance();
    if ( instance_p == NULL )
    {
        printf("Socket constructor error: no wifly instance available!\r\n");
    }

    int recvdata = 0;
    printf("uartRecvThread\r\n");

    /* UART recv thread main loop */
    for (;;) 
    {
        Thread::signal_wait(1);
//        wait(0.1);      
        recvdata = instance_p->mUart.getc();
        printf( "[thread]%02x\r\n", recvdata );
    }
}

