/******************* Murata Manufacturing Co.,Ltd. 2014 *****************
 *
 * Filename:   SNIC_UartCommandManager.cpp
 *
 * Purpose:    This module has implementation of function for management of 
               SNIC UART Command.
 *              
 * $Author: kishino $
 *
 * $Date: 2014/03/26 $
 *
 * $Revision: 0.0.0.1 $
 * ***********************************************************************/
#include "SNIC_UartCommandManager.h"
#include "SNIC_Core.h"

C_SNIC_UartCommandManager::~C_SNIC_UartCommandManager()
{
}

void C_SNIC_UartCommandManager::setCommandID( unsigned char cmd_id )
{
    mCommandID = cmd_id;
}

unsigned char C_SNIC_UartCommandManager::getCommandID()
{
    return mCommandID;
}

void C_SNIC_UartCommandManager::setCommandSID( unsigned char cmd_sid )
{
    mCommandSID = cmd_sid;
}

unsigned char C_SNIC_UartCommandManager::getCommandSID()
{
    return mCommandSID;
}

void C_SNIC_UartCommandManager::setCommandStatus( unsigned char status )
{
    mCommandStatus = status;
}

unsigned char C_SNIC_UartCommandManager::getCommandStatus()
{
    return mCommandStatus;
}

void C_SNIC_UartCommandManager::setResponseBuf( unsigned char *buf_p )
{
    mResponseBuf_p = buf_p;
}

unsigned char *C_SNIC_UartCommandManager::getResponseBuf()
{
    return mResponseBuf_p;
}

void C_SNIC_UartCommandManager::setScanResultHandler( void (*handler_p)(tagSCAN_RESULT_T *scan_result) )
{
    mScanResultHandler_p = handler_p;
}


int C_SNIC_UartCommandManager::wait()
{
    int ret = 0;

    // Get thread ID
    mCommandThreadID = osThreadGetId();
    
    // Signal flags that are reported as event are automatically cleared.
    osEvent event_ret = osSignalWait( UART_COMMAND_SIGNAL, UART_COMMAND_WAIT_TIMEOUT);
    if( event_ret.status != osEventSignal )
    {
        ret = -1;
    }

    return ret;
}

int C_SNIC_UartCommandManager::signal()
{
    // set signal
    return osSignalSet(mCommandThreadID, UART_COMMAND_SIGNAL);
}

bool C_SNIC_UartCommandManager::isWaitingCommand( unsigned int command_id, unsigned char *payload_p )
{
    bool ret = false;

    if( (command_id == getCommandID())
        && (payload_p[0] == getCommandSID()) )
    {
        ret = true;
    }
    return ret;
}

void C_SNIC_UartCommandManager::scanResultIndicate( unsigned char *payload_p, int payload_len )
{
    if( (payload_p == NULL) || (mScanResultHandler_p == NULL) )
    {
        return;
    }
    
    tagSCAN_RESULT_T scan_result;
    int ap_count  = payload_p[2];
    
    if( ap_count == 0 )
    {
        mScanResultHandler_p( NULL );
    }
    
    unsigned char *ap_info_p = &payload_p[3];
    int ap_info_idx = 0;

    for( int i = 0; i < ap_count; i++ )
    {
        scan_result.channel = ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.rssi    = (signed)ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.security= ap_info_p[ap_info_idx];
        ap_info_idx++;
        memcpy( scan_result.bssid, &ap_info_p[ap_info_idx], BSSID_MAC_LENTH );
        ap_info_idx += BSSID_MAC_LENTH;
        scan_result.network_type= ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.max_rate= ap_info_p[ap_info_idx];
        ap_info_idx++;
        ap_info_idx++;  // reserved
        strcpy( scan_result.ssid, (char *)&ap_info_p[ap_info_idx] );
        ap_info_idx += strlen( (char *)&ap_info_p[ap_info_idx] );
        ap_info_idx++;
        
        // Scanresult callback
        mScanResultHandler_p( &scan_result );
    }
}

void C_SNIC_UartCommandManager::bufferredPacket( unsigned char *payload_p, int payload_len )
{
    if( (payload_p == NULL) || (payload_len == 0) )
    {
        return;
    }
    
    C_SNIC_Core *instance_p = C_SNIC_Core::getInstance();
    
    int             socket_id;
    unsigned short  recv_len;
    
    // Get socket id from payload
    socket_id = payload_p[2];
    // Get Connection information
    C_SNIC_Core::tagCONNECT_INFO_T *con_info_p = instance_p->getConnectInfo( socket_id );
    if( con_info_p == NULL )
    {
        return;
    }
    
    if( con_info_p->is_connected == false )
    {
        printf(" Socket id \"%d\" is not connected\r\n", socket_id);
        return;
    }
    
    // Get receive length from payload
    recv_len= ((payload_p[3]<<8) & 0xFF00) | payload_p[4];
    for( int i = 0; i < recv_len; i++ )
    {
        if( con_info_p->recvbuf_p->isFull() )
        {
            printf("Receive buffer is full.\r\n");
            break;
        }
        
        // Add to receive buffer
        con_info_p->recvbuf_p->queue( payload_p[5+i] );
    }
    con_info_p->is_received = true;
}
