#ifndef _YD_WIFIINTERFACE_H_
#define _YD_WIFIINTERFACE_H_

#include "YDwifi.h"

namespace murata_wifi
{

class C_YDwifiInterface: public C_YDwifi {
public:

    /** Constructor
        @param tx mbed pin to use for tx line of Serial interface
        @param rx mbed pin to use for rx line of Serial interface
        @param cts mbed pin to use for cts line of Serial interface
        @param rts mbed pin to use for rts line of Serial interface
        @param reset reset pin of the wifi module
        @param alarm alarm pin of the wifi module (default: NC)
        @param baud baud rate of Serial interface (default: 9600)
    */
    C_YDwifiInterface(PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm = NC, int baud = 9600);

    /** Initialize the interface.
        @return 0 on success, a negative number on failure
    */
    int init();

    /** Get Firmware version string.
        @param  version_p Pointer of FW version string.(null terminated)[output]
        @return 0:success/other:fail
        @note   This function is blocked until a returns.
                When you use it by UI thread, be careful. 
    */
    int getFWVersion( unsigned char *version_p );

#if 0
  /** Connect
  * Bring the interface up, start DHCP if needed.
  * \param sec the Wi-Fi security type
  * \param ssid the Wi-Fi SSID
  * \param phrase the Wi-Fi passphrase or security key
  * \param mode the Wi-Fi mode
  * \return 0 on success, a negative number on failure
  */
  int connect(Security sec, const char* ssid, const char* phrase, WiFiMode mode = WM_INFRASTRUCTURE);
  
  /** Disconnect
  * Bring the interface down
  * \return 0 on success, a negative number on failure
  */
  int disconnect();
  
  /** Get the MAC address of your Ethernet interface
   * \return a pointer to a string containing the MAC address
   */
  char* getMACAddress();
  
  /** Get the IP address of your Ethernet interface
   * \return a pointer to a string containing the IP address
   */
  char* getIPAddress();

  /** Get the Gateway address of your Ethernet interface
   * \return a pointer to a string containing the Gateway address
   */
  char* getGateway();
 
  /** Get the Network mask of your Ethernet interface
   * \return a pointer to a string containing the Network mask
   */
  char* getNetworkMask();
#endif
};
}

#endif  /* _YD_WIFIINTERFACE_H_ */