#include "YDwifiInterface.h"
#include "YDwifi_uartmsg.h"

using namespace murata_wifi;

#define MEMPOOL_BLOCK_SIZE  2048
typedef struct
{
    unsigned char buf[MEMPOOL_BLOCK_SIZE];
}tagMEMPOOL_BLOCK_T;
#define MEMPOOL_PAYLOAD_NUM 1
/** MemoryPool for payload of UART response */
MemoryPool<tagMEMPOOL_BLOCK_T, MEMPOOL_PAYLOAD_NUM>     gMEMPOOL_PAYLOAD;

#define UART_REQUEST_PAYLOAD_MAX    512

C_YDwifiInterface::C_YDwifiInterface( PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud):
    C_YDwifi(tx, rx, cts, rts, reset, alarm, baud)
{
}

int C_YDwifiInterface::init()
{
    /* Initialize UART */
    initUart();
    return 0;
}

int C_YDwifiInterface::getFWVersion( unsigned char *version_p )
{
    // Get buffer for response payloadfrom MemoryPool
    tagMEMPOOL_BLOCK_T *payload_buf = gMEMPOOL_PAYLOAD.alloc();
    if( payload_buf == NULL )
    {
        printf("getFWVersion payload_buf NULL\r\n");
        return -1;
    }

    tagGEN_FW_VER_GET_REQ_T req;
    unsigned char payload_array[UART_REQUEST_PAYLOAD_MAX];
    unsigned char command_array[UART_REQUEST_PAYLOAD_MAX];
    unsigned short payload_len;
    unsigned int   command_len;
    int ret;
    
    // Make request
    req.cmd_sid = UART_CMD_SID_GEN_FW_VER_GET_REQ;
    req.seq = mUartRequestSeq++;
    
    // Make command payload
    payload_len = C_YD_UartMsg::makePayload( sizeof(tagGEN_FW_VER_GET_REQ_T), (unsigned char *)&req, payload_array );
    // Make all command request
    command_len = C_YD_UartMsg::makeRequest( UART_CMD_ID_GEN, payload_array, payload_len, command_array );

    // Set data for response
    mUartCommand.setCommandID( UART_CMD_ID_GEN );
    mUartCommand.setCommandSID( UART_CMD_SID_GEN_FW_VER_GET_REQ );
    mUartCommand.setResponseBuf( payload_buf->buf );
    
    // Send uart command request
    sendUart( command_len, command_array );
    
    // Wait UART response
    ret = mUartCommand.wait();
    printf( "getFWversion wait:%d\r\n", ret );
    if( ret != 0 )
    {
        printf( "getFWversion failed\r\n" );
        gMEMPOOL_PAYLOAD.free( payload_buf );
        return -1;
    }
    
    printf("getFWversion status:%02x\r\n", mUartCommand.getCommandStatus());
    if( mUartCommand.getCommandStatus() == 0 )
    {
        unsigned char version_len = payload_buf->buf[3];
        memcpy( version_p, &payload_buf->buf[4], version_len );
    }
    gMEMPOOL_PAYLOAD.free( payload_buf );
    return 0;
}
