#include "YDwifiUartCommand.h"

using namespace murata_wifi;

void C_YDwifiUartCommand::setCommandID( unsigned char cmd_id )
{
    mCommandID = cmd_id;
}

unsigned char C_YDwifiUartCommand::getCommandID()
{
    return mCommandID;
}

void C_YDwifiUartCommand::setCommandSID( unsigned char cmd_sid )
{
    mCommandSID = cmd_sid;
}

unsigned char C_YDwifiUartCommand::getCommandSID()
{
    return mCommandSID;
}

void C_YDwifiUartCommand::setCommandStatus( unsigned char status )
{
    mCommandStatus = status;
}

unsigned char C_YDwifiUartCommand::getCommandStatus()
{
    return mCommandStatus;
}

void C_YDwifiUartCommand::setResponseBuf( unsigned char *buf_p )
{
    mResponseBuf_p = buf_p;
}

unsigned char *C_YDwifiUartCommand::getResponseBuf()
{
    return mResponseBuf_p;
}


int C_YDwifiUartCommand::wait()
{
    int ret = 0;
    // Get thread ID
    mCommandThreadID = osThreadGetId();
    
    // Signal flags that are reported as event are automatically cleared.
    osEvent event_ret = osSignalWait( UART_COMMAND_SIGNAL, UART_COMMAND_WAIT_TIMEOUT);
    if( event_ret.status != osEventSignal )
    {
        ret = -1;
    }
    return ret;
}

int C_YDwifiUartCommand::signal()
{
    // set signal
    return osSignalSet(mCommandThreadID, UART_COMMAND_SIGNAL);;
}

bool C_YDwifiUartCommand::isWaitingCommand( unsigned int command_id, unsigned char *payload_p )
{
    bool ret = false;

    if( (command_id == getCommandID())
        && (payload_p[0] == (getCommandSID() | 0x80) ) )
    {
        ret = true;
    }
    return ret;
}

