#include "initalize.h"  //Funktionenprototypen
#include "alphabet.h"   //Header mit allen Buchstaben und Zeichen Variationen
#include "mbed.h"       //
#include <string>       //
#include "rtos.h"       //Verwendet für RtosTimer
#include <BufferedSerial.h> //MCU besitzt eine Buffer-Limite von 16 bytes. Diese Library erweitert diese Limite
#include "DS3231.h"     //Library für die Echtzeituhr DS3231
#include "project.h"    //Definitionen
#include "time_adjustment_dates.h"  //Daten für die Winter und Sommerzeit

//============================================================================================
//VARIABLEN


struct LED_Matrix
{
    DigitalOut ds,oe,stcp,shcp,mr;
    LED_Matrix(PinName pin1, PinName pin2, PinName pin3, PinName pin4, PinName pin5) : ds(pin1), oe(pin2), stcp(pin3), shcp(pin4), mr(pin5) {};    
};
//PIN-ASSIGNMENT------------------------------------------------------------------------------
DS3231      RTC(p28,p27);   //RTC über p28(SDA) und p27(SCL) verbunden

BusOut      led(LED1,LED2,LED3,LED4);   

LED_Matrix  matrix(p5, p6, p7, p8, p9); //LED-Matrix Data, Enable, Storage, Shift, Masterreset

RtosTimer   customDuration(CustomTextCycleFinished);    //Timer für benutzerdefinierter Text
RtosTimer   TimerTextSwitch(textSwitcher);              //Timer für den Wechsel zwischen Zeit und Datum

BufferedSerial bluetooth(p13,p14); //Bluetooth Modul, tx, rx

//GLOBAL VARIABLE----------------------------------------------------------------------------------
//Clock
int     rtc_hour;       //Stunden
int     rtc_minute;     //Minuten
int     rtc_second;     //Sekunden
int     rtc_date;       //Datum
int     rtc_dayOfWeek;  //Tag der Woche
int     rtc_month;      //Monat
int     rtc_year;       //Jahr
//
//Time Values
int     CustomDuration = TIME_CUSTOM_DEF;

//bluetooth
string  TextBluetooth ("");
char    ErrorValue = 0;

//matrix
bool    matrix_setScroll = 1;
char    textSwitch = matrixTIME;
string  TextMatrix    ("");

int     matrixPos = 0;
int     matrix_frames;              // Bilder-Counter
int     matrix_moveFrame = 0;       // Variable zum Verschieben des Textes


//ENUM & STRUCT-------------------------------------------------------------------------------

//============================================================================================

//============================================================================================
//▄     ▄  ▄▄▄  ▄▄▄▄▄ ▄▄▄▄  ▄▄▄ ▄   ▄
//█▀▄ ▄▀█ █   █   █   █   █  █  █   █
//█  ▀  █ █▄▄▄█   █   █▄▄▄▀  █   ▀▄▀
//█     █ █   █   █   █ ▀▄   █  ▄▀ ▀▄
//█     █ █   █   █   █  ▀▄ ▄█▄ █   █
//MATRIX=======================================================================
//Autor:        Joel von Rotz
//Typ:          void
//parameter:    int m_length,   int m_height,   char *matrix_value
//              Matrixlänge     Matrixhöhe      Array für Textwerte
//Beschreibung: 
//=============================================================================
void Matrix(int m_length, int m_height, char *matrix_value)
{
    matrix.oe = 1;                //Matrix ausschalten, damit keine unerwünschte LEDs leuchten.
    TextMatrix = TextStandard;  //Standard-Text zuweisen
    wait(0.5);
    matrix.oe = 0;                //Matrix wieder einschalten
    
    RTC.setI2Cfrequency(400000);
    bluetooth.baud(115200); //Bluetooth Module Communication
    
    TimerTextSwitch.start(TIME_CHANGE);
    
    while(1)
    {
        initVal();          //Variabeln initialisieren
        
        for(int x = 0; x < 512; x++)   //matrix_value "leeren"
            matrix_value[x] = 0x00;
        
        
        ReadTimeToString();    //Lese Zeit und konvertiere zu einem String
        
        
        TextMatrixConvert(TextMatrix,matrix_value, m_length);
        
        /*Überprüft ob es sich um Winterzeit oder Sommerzeit handelt*/
        WinterSummerTime(rtc_year,rtc_month,rtc_date,rtc_hour,rtc_second);
        //----------------------------//
        if((matrix_frames-64) > m_length)
        {   
            matrix_setScroll = 1;   
        }
        else
        {   
            matrix_setScroll = 0;   
        }
        if(!matrix_setScroll)
        {   
            matrix_moveFrame = 64;  
        }
        //----------------------------//
        setMatrix(m_height, m_length, matrix_value);
        //----------------------------//
        if(bluetooth.readable())
        {
            bluetooth_matrix(m_length,m_height,matrix_value);
        }
        //----------------------------//
    }
}

//TEXTSWITCHER=================================================================
//Autor:        Joel von Rotz
//Typ:          void
//parameter:    void
//Beschreibung: Wird für das Wechseln des Textes benötigt
//=============================================================================
void textSwitcher(void)
{
    matrixPos = 0;
    matrix_moveFrame = 0;
    textSwitch = !textSwitch;
}

void CustomTextCycleFinished(void)
{
    TimerTextSwitch.start(TIME_CHANGE);
    customDuration.stop();
    textSwitch = matrixTIME;
    TextMatrix = TextStandard;
    
}

//INITVAL======================================================================
//Autor:        Joel von Rotz
//Typ:          void
//parameter:    void
//Beschreibung: Initialisierung der Variabeln und Ein-Ausgängen
//=============================================================================
void initVal(void)
{
    //Überprüfung, ob Text verschoben werden muss auf dem Display
    
    //=====================
    //Output
    matrix.mr = 1;
    matrix.oe = 1;
    matrix.ds = 0;
    matrix.stcp = 0;
    matrix.shcp = 0;
    //=====================
    //Variabeln
    matrix_frames = 0;
    TextBluetooth = "";
    reset_srg();
}

//MATRIX=======================================================================
//Autor:        Joel von Rotz
//Typ:          void
//parameter:    int m_height, int m_length, char *matrix_value
//Beschreibung: Lässt Text oder anderes auf einer LED-Matrix anzeigen
//=============================================================================
//  MATRIX
//Lässt einen Text auf dem Display anzeigen
void setMatrix(int m_height,int m_length, char *matrix_value)
{  
    //clock wird als Zählvariable verwendet, darunter als Bitshifter und Multiplexer
    for(int frequency = 0; frequency < 4; frequency++)
    {
        for(int clock = 0; clock < 8; clock++)
        {
            //Der Text muss von hinten nach vorne abgearbeitet werden, darum wird eine Variable
            //names matrixPos verwendet, die die Position des Textes bestimmt.
            if(matrixPos <= 0)
                matrixPos = m_length;   //setze matrixPos auf die letzte Position des Textes zurück
                
    
            for(int fill = 0; fill < (m_length/8); fill++)
            {
                for(int column = 8; column > 0; column--)
                {
                    matrix.ds = (matrix_value[matrixPos-column+matrix_moveFrame] >> clock) & 1;
                    shift_srg();
                }
                matrixPos -= 8;
            }
            //Multiplexer
            //mit dieser For-Schleife wird der Multiplex-Bit gesetzt
            for(int cell = 0; cell < 8; cell++)
            {
                if(clock == cell)   //ist clock gleich cell?
                    matrix.ds = 1;      //setze Data-Pin auf 1
                else                //Sonst
                    matrix.ds = 0;      //setze auf 0
                shift_srg();        //Schiebe Data in die Register hinein
            }
            
            store_srg();
            matrix.oe = 0;
            wait_us(1000);
            matrix.oe = 1;
        }
        
    }
    //===================================================================
    if(matrix_setScroll) 
    {
        matrix_moveFrame++;
    }
    if(matrix_moveFrame >= matrix_frames)
    {
        matrix_moveFrame = 0; 
    }
    //===================================================================
}


//Schieberegister mit einem Bit befüllen
void shift_srg()
{
    matrix.shcp = 1;   
    matrix.shcp = 0;
}

//Speicher von den Schieberegister herausgeben
void store_srg()
{
    matrix.stcp = 1;
    matrix.stcp = 0;
}

//Schieberegister zurücksetzen
void reset_srg()
{
    matrix.mr = 0;
    matrix.mr = 1;   
}

/*Steuerung für die LED-Matrix*/
void bluetooth_matrix(int m_length, int m_height, char *matrix_value)
{
    TextBluetooth = "";            
    ErrorValue = NO_ERROR;
    string buff;
    
    while(bluetooth.readable())
    {
        TextBluetooth += bluetooth.getc();   
    }
    //------------------------------------------
    //Bluetooth Nachrichten
    if(TextBluetooth.size()==28 && TextBluetooth.find("matrixCONNECT") != string::npos)
    {
        TextMatrix = "Connected!";    
        bluetooth.printf("Hallo! Schreibe etwas...");
    }
    else if(TextBluetooth.size()==17 && TextBluetooth.find("matrixNEW_PAIRING") != string::npos ||
            TextBluetooth.size()==16 && TextBluetooth.find("matrixDISCONNECT") != string::npos  )
    {
        TextBluetooth = "";
    }
    //------------------------------------------
    //Zeit einstellen
    else if(TextBluetooth.at(0) == '?') //ist das erste Zeichen ein Befehlszeichen
    {   
        TextBluetooth.erase(0,1);
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        if(TextBluetooth.find("ST ")== 0)   //Konfiguration Zeit
        {   TextBluetooth.erase(0,3);
            if(TextBluetooth.size() == 8)
            {
                
                buff.assign(TextBluetooth,0,2);
                rtc_hour = atoi(buff.c_str());
                buff.assign(TextBluetooth,3,2);
                rtc_minute = atoi(buff.c_str());
                buff.assign(TextBluetooth,6,2);
                rtc_second = atoi(buff.c_str());
                if(rtc_hour <= 23 && rtc_minute <= 59 && rtc_second <= 59)
                {
                    RTC.setTime(rtc_hour,rtc_minute,rtc_second);
                }
                else
                {   
                    ErrorValue = CMD_NOT_IN_RANGE;
                }
            }
            else
            {   
                ErrorValue = CMD_NOT_COMPLETE;
            }
        }
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        else if(TextBluetooth.find("SD ")== 0)  //Konfiguration Datum
        {   TextBluetooth.erase(0,3);
            if(TextBluetooth.size() == 10)
            {
                /*Konvertiere String zu Int*/
                buff.assign(TextBluetooth,0,2);
                rtc_date = atoi(buff.c_str());
                buff.assign(TextBluetooth,3,2);
                rtc_month = atoi(buff.c_str());
                buff.assign(TextBluetooth,6,4);
                rtc_year = atoi(buff.c_str());
                if(rtc_year <= 2100 && rtc_year >= 1900 && checkDate(rtc_year,rtc_month,rtc_date))
                {
                    RTC.setDate(0,rtc_date,rtc_month,rtc_year);
                }
                else if( ErrorValue == FEB_NO_LEAP) {}
                else
                {   
                    ErrorValue = CMD_NOT_IN_RANGE;
                }
            }
            else
            {   
                ErrorValue = CMD_NOT_COMPLETE;   
            }
        }
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        else if(TextBluetooth.find("SW ")== 0)  //Konfiguration Winterzeit
        {   TextBluetooth.erase(0,3);
            TextBluetooth = "Winterzeit";
        }
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        else if(TextBluetooth.find("SS ")== 0)  //Konfiguration Sommerzeit
        {   TextBluetooth.erase(0,3);
            TextBluetooth = "Sommerzeit";
        }
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        else if(TextBluetooth.find("CD ")== 0)  //Konfiguration Benutzerdefinierte Textdauer
        {   TextBluetooth.erase(0,3);
            if(TextBluetooth.size() == 3)
            {
                CustomDuration = atoi(TextBluetooth.c_str());
                if(CustomDuration <= 600 && CustomDuration >= 1){}
                else
                {
                    ErrorValue = CMD_NOT_IN_RANGE;
                    CustomDuration = TIME_CUSTOM_DEF;
                }
            }
            else
            {   
                ErrorValue = CMD_NOT_COMPLETE;   
            }
        }
        /*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
        else
        {
            ErrorValue = INVALID_CMD;
        }
        BLE_ErrorHandler(ErrorValue);
    }
    //-----------------------------------------------------
    //Benutzerdefinierter Text
    else
    {
        TextMatrix = TextBluetooth;
        textSwitch = matrixCUSTOM;
        TimerTextSwitch.stop();         //Stoppe den Timer für den Zeit-Datum-Wechsel
        customDuration.start(CustomDuration*1000);   //2 Minuten eigener Text
    }
}

void BLE_ErrorHandler(char value)
{
    switch(value)
    {
    case NO_ERROR:
        TimerTextSwitch.start(TIME_CHANGE);
        customDuration.stop();
        textSwitch = matrixTIME;
        break;
    case INVALID_CMD:
        TextMatrix = "ERROR: Invalid Command";
        break;
    case CMD_NOT_COMPLETE:
        TextMatrix = "ERROR: Missing Command Parameters";
        break;
    case CMD_NOT_IN_RANGE:
        TextMatrix = "ERROR: Values Not In Range";
        break;
    case FEB_NO_LEAP:
        TextMatrix = "ERROR: February-Date Too Big (Not a Leapyear)";
        break;
    }
    if(value != NO_ERROR)
    {
        textSwitch = matrixCUSTOM;
        TimerTextSwitch.stop();         //Stoppe den Timer für den Zeit-Datum-Wechsel
        customDuration.start(10000);   //2 Minuten eigener Text
    }
}

void WinterSummerTime(int yearVal,int monthVal,int dateVal,int hourVal,int secondVal)
{
    /*timeLock wird als Wiederholungsstop verwendet. Da bei der Winterzeit eine Stunden *
     *zurückgestellt wird, wird die Zeit immer wieder um eine Stunde zurückgestellt.    */
    static bool timeLock = 0;
    
    //Summertime
    if( dateVal  == summerdates[(yearVal % 2000)][0] &&
        monthVal == summerdates[(yearVal % 2000)][1] &&
        (yearVal % 2000)== summerdates[(yearVal % 2000)][2] &&
        hourVal  == summerdates[(yearVal % 2000)][3] &&
        secondVal== summerdates[(yearVal % 2000)][4] &&
        timeLock == 1)
    {
        timeLock = 0;
        hourVal += 1;
        RTC.setTime(hourVal,rtc_minute,rtc_second);
    }
    //WINTERTIME
    if( dateVal  == winterdates[(yearVal % 2000)][0] &&
        monthVal == winterdates[(yearVal % 2000)][1] &&
        (yearVal % 2000)== winterdates[(yearVal % 2000)][2] &&
        hourVal  == winterdates[(yearVal % 2000)][3] &&
        secondVal== winterdates[(yearVal % 2000)][4] &&
        timeLock == 0)
    {
        timeLock = 1;
        hourVal -= 1;
        RTC.setTime(hourVal,rtc_minute,rtc_second);
    }
}

//=============================================================================


//TimeStringConvert============================================================
//Autor:        Joel von Rotz
//Typ:          void
//parameter:    void
//Beschreibung: 
//      Das Datum und die Uhrzeit wird am Terminal angezeigt.
//=============================================================================
void ReadTimeToString(void)
{
    RTC.readDateTime(&rtc_dayOfWeek,&rtc_date,&rtc_month,&rtc_year,&rtc_hour,&rtc_minute,&rtc_second);
    char buff[100];
    if(textSwitch == matrixTIME)
    {
        sprintf(buff,"   %02i:%02i:%02i",rtc_hour,rtc_minute,rtc_second);
        
    }
    else if(textSwitch == matrixDATE)
    {    
        sprintf(buff,"  %02i.%02i.%04i",rtc_date,rtc_month,rtc_year);
    }
    if(textSwitch != matrixCUSTOM)
    {
        TextMatrix = buff;
    }
}
//=============================================================================

//SETDATEMAX===================================================================
//Autor:        Joel von Rotz
//Typ:          char
//parameter:    int monthVal (Monat wird übergeben)
//Beschreibung: 
//      Es wird anhand dem Monat die dazugehörigen maximalen Tagen zurück-
//      gegeben.
//=============================================================================
bool checkDate(int yearVal, int monthVal, int dateVal)
{
    const char month_limit[12]={31,28,31,30,31,30,31,31,30,31,30,31};
    if(monthVal == februar && checkLeapyear(yearVal))
    {   return true;    }
    else if(dateVal > 28 && monthVal == februar)
    {   
        ErrorValue = FEB_NO_LEAP;
        return false;   
    }
    if(dateVal <= month_limit[monthVal-1] && dateVal >= 1)
    {   return true;    }
    else
    {   return false;   }
}
//=============================================================================


//CHECKLEAPYEAR================================================================
//Autor:        Joel von Rotz
//Typ:          bool
//parameter:    int yearVal
//Beschreibung: 
//  Es wird überprüft, ob das Jahr ein Schaltjahr ist oder nicht.
//  Dabei ist das Jahr NUR ein Schaltjahr, wenn das Jahr durch 4 oder durch 400 
//  teilbar, aber sobald es durch 100 teilbar ist, ist es kein Schaltjahr.
//  Source -> Gregorianischer Kalender 
//=============================================================================
#define ISLEAPYEAR    1
#define ISNOTLEAPYEAR 0
bool checkLeapyear(int yearVal)
{
    if(yearVal % 4 == 0)
    {
        if(yearVal % 100 == 0)
        {
            if(yearVal % 400 == 0)
            {
                return ISLEAPYEAR;   //ist Schaltjahr
            }
            return ISNOTLEAPYEAR;   //ist nicht Schaltjahr
        }
        return ISLEAPYEAR;   //ist Schaltjahr
    }
    return ISNOTLEAPYEAR;   //ist nicht Schaltjahr
}
//=============================================================================

void initArray(int const *letter, int size, char *matrix_value)
{
    matrix_frames = matrix_frames + 1;  /*A small space, about 1 led column, is being added.        */
    
    for(int position = 0; position < size; position++)
    {
        /*  Hex-values are added to the matrix-text and matrix_frames is incremented          */
        matrix_value[matrix_frames] = letter[position];
        matrix_frames++;
    }
    matrix_value[matrix_frames] = 0x00;           
}

//=============================================================================//
//=============================================================================//
void TextMatrixConvert(const string& text_convertion, char *matrix_value, int m_length)      
{
    matrix_frames = matrix_frames + 64;
    for(int LetterPos = 0; LetterPos < text_convertion.size(); LetterPos++)
    {
        //Letters ------------------------
        if     (text_convertion.at(LetterPos) == 'A')
        {   
            initArray(A,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'a')
        {   
            initArray(a,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'B')
        {   
            initArray(B,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'b')
        {   
            initArray(b,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'C')
        {   
            initArray(C,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'c')
        {   
            initArray(c,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'D')
        {   
            initArray(D,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'd')
        {   
            initArray(d,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'E')
        {   
            initArray(E,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'e')
        {   
            initArray(e,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'F')
        {   
            initArray(F,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'f')
        {   
            initArray(f,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'G')
        {   
            initArray(G,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'g')
        {   
            initArray(g,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'H')
        {   
            initArray(H,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'h')
        {   
            initArray(h,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'I')
        {   
            initArray(I,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'i')
        {   
            initArray(i,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'J')
        {   
            initArray(J,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'j')
        {   
            initArray(j,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'K')
        {   
            initArray(K,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'k')
        {   
            initArray(k,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'L')
        {   
            initArray(L,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'l')
        {   
            initArray(l,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'M')
        {   
            initArray(M,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'm')
        {   
            initArray(m,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'N')
        {   
            initArray(N,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'n')
        {   
            initArray(n,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'O')
        {   
            initArray(O,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'o')
        {   
            initArray(o,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'P')
        {   
            initArray(P,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'p')
        {   
            initArray(p,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'Q')
        {   
            initArray(Q,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'q')
        {   
            initArray(q,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'R')
        {   
            initArray(R,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'r')
        {   
            initArray(r,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'S')
        {   
            initArray(S,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 's')
        {   
            initArray(s,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'T')
        {   
            initArray(T,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 't')
        {   
            initArray(t,3,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'U')
        {   
            initArray(U,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'u')
        {   
            initArray(u,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'V')
        {   
            initArray(V,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'v')
        {   
            initArray(v,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'W')
        {   
            initArray(W,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'w')
        {   
            initArray(w,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'X')
        {   
            initArray(X,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'x')
        {   
            initArray(x,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'Y')
        {   
            initArray(Y,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'y')
        {   
            initArray(y,5,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'Z')
        {   
            initArray(Z,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == 'z')
        {   
            initArray(z,4,matrix_value);   
        }
        // Numbers -----------------------
        else if(text_convertion.at(LetterPos) == '0')
        {   
            initArray(zero,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '1')
        {   
            initArray(one,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '2')
        {   
            initArray(two,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '3')
        {   
            initArray(three,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '4')
        {   
            initArray(four,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '5')
        {   
            initArray(five,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '6')
        {   
            initArray(six,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '7')
        {   
            initArray(seven,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '8')
        {   
            initArray(eight,4,matrix_value);   
        }
        else if(text_convertion.at(LetterPos) == '9')
        {   
            initArray(nine,4,matrix_value);
        }
        // Symbols -----------------------
        else if(text_convertion.at(LetterPos) == '!')
        {   
            initArray(exclam,1,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '?')
        {   
            initArray(quest,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  34)
        {  
            initArray(quote,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '#')
        {   
            initArray(hash,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '$')
        {   
            initArray(dollar,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '%')
        {   
            initArray(prcent,7,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '&')
        {   
            initArray(_and,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '(')
        {   
            initArray(round_o,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == ')')
        {   
            initArray(round_c,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '*')
        {   
            initArray(star,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '+')
        {   
            initArray(plus,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '-')
        {   
            initArray(minus,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '=')
        {   
            initArray(_equal,4,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == ',')
        {   
            initArray(comma,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '.')
        {   
            initArray(point,1,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '/')
        {   
            initArray(slash,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  58)
        {   
            initArray(d_point,1,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  59)
        {   
            initArray(poicom,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  95)
        {   
            initArray(undlin,4,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  92)
        {   
            initArray(b_slash,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  64)
        {   
            initArray(at,5,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  62)
        {   
            initArray(more,4,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  60)
        {   
            initArray(less,4,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '[')
        {   
            initArray(brack_o,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == ']')
        {   
            initArray(brack_c,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) ==  94)
        {   
            initArray(roof,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '{')
        {   
            initArray(brace_o,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '}')
        {   
            initArray(brace_c,3,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '~')
        {   
            initArray(wave,4,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '|')
        {   
            initArray(stick,1,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == '`')
        {   
            initArray(frapo,2,matrix_value);
        }
        else if(text_convertion.at(LetterPos) == ' ')
        {   
            initArray(space,3,matrix_value);
        }
    }
}

//============================================================================================
//▄▄▄   ▄▄   ▄▄   ▄▄   ▄▄   ▄
//█  █ █  ▀ ▀  █ ▀  █ ▀  █ ▀█
//█  █ ▀▄▄   ▄▄▀  ▄▄▀  ▄▄▀  █
//█  █    █    █ █       █  █
//█▄▄▀ ▀▄▄▀ ▀▄▄▀ ▀▄▄▀ ▀▄▄▀ ▄█▄