#include <mbed.h>
#include <string>
#include <ctype.h>


//------------------------------------------------------------------------------------------------------
// Analog I/O, Digital I/O, etc.
//------------------------------------------------------------------------------------------------------
DigitalOut  ds1(p5), ds2(p10),  oe1(p6),  stcp1(p7),  shcp1(p8),  mr1(p9),  led(LED1);

/*
DS    normal        Serial Data Output  Schreibt vor ob das LED 0 oder 1 ist.
OE    invertiert    Output-Enable       Aktiviert oder deaktiviert die LEDs.
SHCP  normal        Shift register clk  Setzt Position mit kurzen Impulsen fest.
STCP  normal        Storage reg. clk    Setzt Reihe mit kurzen Impulsen fest.
MR    invertiert    Master reset        resetet den Storage. Muss mit STCP angezeigt werden.
*/

//  ,,,,,
//  |xox|  
//  |oxo|
//  |xox|
//  '''''


//------------------------------------------------------------------------------------------------------
// Voids & Ticker, Ints, etc.
//------------------------------------------------------------------------------------------------------
int a, b, x, y, z=0, t, temp;

int const data[][8] = {   {0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01},
                          {0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03},
                          {0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07},
                          {0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f},
                          {0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f},
                          {0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f},
                          {0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f},
                          {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
                          {0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe},
                          {0xfc,0xfc,0xfc,0xfc,0xfc,0xfc,0xfc,0xfc},
                          {0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8},
                          {0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0},
                          {0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0},
                          {0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0},
                          {0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80},
                          {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};

int const size_y = sizeof(data)     /   sizeof(data[0]);
int const size_x = sizeof(data[0])  /   sizeof(data[0][0]);

bool row_temp[8][8]= {{},{},{},{},{},{},{},{}};
void save_srg(), reset_srg();   //, set_srg(bool status_[]);
//------------------------------------------------------------------------------------------------------


//------------------------------------------------------------------------------------------------------
// Main
//------------------------------------------------------------------------------------------------------
int main()
{
    oe1=1;
    reset_srg();
    oe1=0;
    while(1)
    {   
        for(y = 0; y < size_y; y++)       // Frames
        {
            for(t = 0; t < 80; t++)      // Zeit
            {
                for(a = 0; a < size_x; a++)        // row_temp befüllen
                {
                    temp=data[y][a];
                    for(x = 0; x < size_x; x++)
                    {
                        row_temp[a][x]=(temp >> x) & 1;
                    }                    
                }   // Ende for-a
                for(z = 0; z < size_x; z++)
                {
                    for(a=0;a<8;a++)
                    {
                        ds2 = 1;
                        ds1 = row_temp[z][a];
                        save_srg();
                    }   // Ende for-a
                    stcp1 = 1;
                    stcp1 = 0;
                    wait_ms(1);
                    
                    
                }   // Ende for-z
            }   // Ende for-t
        }   // Ende for-y
    }   // Ende while
}   // Ende main


//------------------------------------------------------------------------------------------------------
// Voids & Floats
//------------------------------------------------------------------------------------------------------

void save_srg()
{
    shcp1 = 1;
    shcp1 = 0;
}


void reset_srg()
{
    mr1 = 0;
    save_srg();
    stcp1 = 1;
    stcp1 = 0;
    
    mr1 = 1;   
}

/*
void set_srg(bool status_[])
{
    for(x=0;x<3;x++)
    {
        ds1 = status_bin[x];
        save_srg();
        wait(0.5);
        stcp1 = 1;
        stcp1 = 0;
    }
    
}*/


/*for(i=0;i<100;i++)
        {
            for(y=0;y<8;y++)
            {
                if(i>=brightness[y])
                    status_bin[y] = false;
                else
                    status_bin[y] = status_[y];
            }
            set_srg(status_bin);
        }*/