/**
 * @brief 
 * 
 * @file twi_master.h
 * @author Joel von Rotz
 * @date 18.07.2018
 */
#ifndef TWI_MASTER_H
#define TWI_MASTER_H
#include "mbed.h"

/**
 * @brief <strong>TWI_Master</strong> is used for interacting with different libraries of I2C sensors, which I wrote.
 * This library has been inspired by the <a href="https://github.com/adafruit/Adafruit_Sensor">Adafruit Sensor-Library</a> 
 * and the <a href="https://github.com/jrowberg/i2cdevlib/">I2Cdevlib</a> by jrowberg.
 * \n\n
 * It is not an I2C driver, since the existing I2C functions are used and new things, such as masking and individual 
 * bit changes, are built in around them.
 * \n\n
 */
class TWI_Master
{
public:
    TWI_Master(PinName sda, PinName scl, uint32_t frequency = 400000);
    void        i2c_write(uint8_t i2c_address, uint8_t slave_address, const uint8_t data);
    void        i2c_writeBits(uint8_t i2c_address, uint8_t slave_address, const uint8_t data, uint8_t mask);
    uint8_t     i2c_readBits(uint8_t i2c_address, uint8_t slave_address, uint8_t mask);
    void        i2c_readSeries(uint8_t i2c_address, uint8_t slave_address, uint8_t *data, uint8_t length);
    uint8_t     i2c_read(uint8_t i2c_address, uint8_t slave_address);

private:
    I2C         m_i2c_sensor;
    uint32_t    m_i2c_frequency;
};

#endif

