#include "mbed.h"

Ticker period;
PwmOut Hi1(p26), Lo1(p23), Hi2(p25), Lo2(p22), Hi3(p24), Lo3(p21);
DigitalOut run(p28), idle(p27);
DigitalIn start(p6);

//void durchlauf(void);
void pulse(void);
void disable(void);
void w1_w2(void);
void w2_w3(void);
void w3_w1(void);
unsigned char mode;
int t, change;

int main()
{
    while(1) {
        run=0;
        idle=1;
        mode=1;
        t=100;
        start.mode(PullNone);
        if(start==0&&mode==1) {
            run=1;
            idle=0;
        } else if (mode>3) {
            mode=1;
        }
        if (run==1) {
            period.attach(&pulse, 0.5);
        } else if (run==0) {
            period.detach();
            idle=1;
        }
        while((mode<=3)&&(run==1)) {}
    }
}



void pulse()
{
    idle=0;
    run=1;
    switch(mode) {
        case 1:
            w1_w2();
            wait_ms(t);
            disable();
            break;

        case 2:
            w2_w3();
            wait_ms(t);
            disable();
            break;

        case 3:
            w3_w1();
            wait_ms(t);
            disable();
            break;
    }
    mode++;
   

}

void disable()
{
    Hi1=0;
    Hi2=0;
    Hi3=0;
    Lo1=0;
    Lo2=0;
    Lo3=0;
}

void w1_w2()
{
    Lo2=1;
    Hi1=1;
}

void w2_w3()
{
    Lo3=1;
    Hi2=1;
}

void w3_w1()
{
    Lo1=1;
    Hi3=1;
}
