#include "mbed.h"
#include "MPL3115A2.h"
 
I2C i2c(p9, p10);       // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
MPL3115A2 sensor(&i2c, &pc);
 
DigitalOut myled(LED1);     
DigitalOut powerPin(p21);   

int main() {
    
    powerPin = 1;
    wait_ms(300);
 
    pc.printf("** MPL3115A2 SENSOR **\r\n");
 
    sensor.init();
 
    pc.printf("Who Am I: 0x%X\r\n", sensor.whoAmI());
 
    Altitude a;
    Temperature t;
    Pressure p;
    
    // Offsets for Dacula, GA
    sensor.setOffsetAltitude(83);
    sensor.setOffsetTemperature(20);
    sensor.setOffsetPressure(-32);
    
    while(1) 
    {
        sensor.readAltitude(&a);
        sensor.readTemperature(&t);
        
        sensor.setModeStandby();
        sensor.setModeBarometer();
        sensor.setModeActive();
        sensor.readPressure(&p);
        
        pc.printf("Altitude: %sm, Temp: %s°C, Pressure: %sPa\r\n", a.print(), t.print(), p.print());
        pc.printf("OFF_H: 0x%X, OFF_T: 0x%X, OFF_P: 0x%X\r\n", sensor.offsetAltitude(), sensor.offsetTemperature(), sensor.offsetPressure());
    
        myled = 1;
        wait(5);
        myled = 0;
        wait(5);
 
        sensor.setModeStandby();
        sensor.setModeAltimeter();
        sensor.setModeActive();
        
    }
}