#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"

C12832_LCD lcd; //Graphics LCD
LM75B tmp(p28,p27); //I2C Temperature Sensor
PwmOut r(p23); //RGB LED with 3 PWM outputs for dimmer control
PwmOut g(p24);
PwmOut b(p25);
PwmOut speaker(p26); //Speaker with PWM driver
AnalogIn pot1(p19); //Reads Pot 1 - near LCD
AnalogIn pot2(p20); //Reads Pot 2 - near RGB LED
Serial pc(USBTX,USBRX); //used for printf to PC over USB

int main ()
{
    float board_temp=0.0;
    float alarm_temp = 0.0;
    // generate a 800Hz tone using PWM hardware output
    speaker.period(1.0/800.0); // 800hz period
    r=1.0; //RGB LED off - PWM 100% duty cycle
    g=1.0;
    b=1.0;

    while (1) {
        lcd.cls();
        lcd.locate(0,0); //clears LCD
        board_temp = tmp; //read temperature
        lcd.printf("Board Temperature = %.2f\n\r",board_temp);
        alarm_temp = 50.0 * pot1; //read alarm temp
        lcd.printf("Temp Alarm Setting = %.2f\n\r",alarm_temp);
        if(board_temp > alarm_temp) { //check temp for alarm
            r = 1.0 - pot2; //RGB LED red
            g = 1.0;
            speaker = 0.5; //alarm tone using PWM
        } else {
            g = 1.0 - pot2; //RGB LED green
            r = 1.0;
            speaker = 0.0;
        }
        wait(1.0);
        pc.printf("%.2f\n\r",board_temp); //send temp to PC
    }
}
