#include "mbed.h"

int count1 = 0;
int count2 = 0;
PwmOut pwm11(D5);           //左正転
PwmOut pwm12(D1);           //左逆転
PwmOut pwm21(D6);           //右正転
PwmOut pwm22(D9);           //右逆転
DigitalOut LED(D2);
InterruptIn button1(A1);    //フォトインタラプタ
InterruptIn button2(A2);    //フォトインタラプタ
AnalogIn   in1(A3);         //フォトリフレクタ左？要確認
AnalogIn   in2(A4);         //フォトリフレクタ真ん中
AnalogIn   in3(A6);         //フォトリフレクタ右？要確認

float thr1 = 0.25f;
float thr2 = 0.25f;
float thr3 = 0.25f;

void flip1() {
    count1++;
}

void flip2() {
    count2++;
}


int main() {
    pwm11.period(0.01f);  //100Hz
    pwm12.period(0.01f);  //100Hz
    pwm21.period(0.01f);  //100Hz
    pwm22.period(0.01f);  //100Hz
    button1.rise(&flip1);
    button2.rise(&flip2);
    
    while(1) {
         
         /*   
            pwm11.write(0.40f);
            pwm12.write(0.10f);
            pwm21.write(0.40f);
            pwm22.write(0.10f);
            */
     //ただただモータを回すプログラム
    //43*2*12
  
    if(  count1 + count2 > 43*2*12){ //LEDを点滅うまくいかない気がする
        LED = 1.0f;
        wait(0.5f);
        LED = 0;
        
        count1 = 0;
        count2 = 0;
        }
        
        printf("%d %d \n",count1,count2);
        
        
        
        if(in1<thr1 && in2>thr2 && in3<thr3){      //白黒白進む
            pwm11.write(0.60f);
            pwm12.write(0.30f);
            pwm21.write(0.60f);
            pwm22.write(0.30f);
            }
            
        else if(in1<thr1 &&in2<thr2 && in3<thr3){ //白白白
            pwm11.write(0.10f);
            pwm12.write(0.10f);
            pwm21.write(0.10f);
            pwm22.write(0.10f);
            }
            
        else if(in1>thr1 && in2<thr3 && in3<thr3){ //黒白白左回転
            pwm11.write(0.60f);
            pwm12.write(0.30f);
            pwm21.write(0.00f);
            pwm22.write(0.00f);
            }
            
        else if(in1<thr1 && in2<thr2 && in3>thr3){ //白白黒右回転
            pwm11.write(0.00f);
            pwm12.write(0.00f);
            pwm21.write(0.60f);
            pwm22.write(0.30f);
            }
            
            
        
        
    }
}