//#define DNS_SERVER_ADDRESS(ipaddr)        (ip4_addr_set_u32(ipaddr, ipaddr_addr("208.67.222.222"))) /* resolver1.opendns.com */

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "SDFileSystem.h"

EthernetInterface eth;

DigitalOut led4(LED4);

//LocalFileSystem local("local");
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "local"); 

static float value = 20;

class AnalogInHandler : public SimpleHandler
{
public:
  AnalogInHandler(const char* rootPath, const char* path, TCPSocketConnection* pTCPSocketConnection) : SimpleHandler(rootPath, path, pTCPSocketConnection) { }
  virtual ~AnalogInHandler() {}

//protected:
  static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocketConnection* pTCPSocketConnection) { return new AnalogInHandler(rootPath, path, pTCPSocketConnection); } //if we ever could do static virtual functions, this would be one
  
  virtual void doGet()
  {
    char buf[20];
    sprintf( buf, "%f", value );
    value += 0.01;
    setContentLen( strlen(buf) );
    respHeaders()["Connection"] = "close";
    writeData(buf, strlen(buf));
  }
  
};

void aliveState(void const *args)
{
    while (true) 
    {
        led4 = !led4;
        Thread::wait(2000);
    }
}

uint32_t do_list(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    uint32_t counter = 0;

    while ((p = readdir(d)) != NULL) {
        counter++;
        printf("%s\n", p->d_name);
    }
    closedir(d);
    return counter;
}

int main()
{
    printf("********* PROGRAM START ***********\r\n");
    Thread thread(aliveState);
    
    // LED's
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::construct<RpcDigitalOut, PinName, const char*>(PTC3, "led1");
    RPC::construct<RpcDigitalOut, PinName, const char*>(PTC2, "led2");
    RPC::construct<RpcDigitalOut, PinName, const char*>(PTA2, "led3");
    
    // Sensoren bringt Linkfehler
    //RPC::add_rpc_class<RpcAnalogIn>();    
    //RPC::construct<RpcAnalogIn, PinName, const char*>(PTB3, "s1");
    //RPCFunction rpcFunc(LcdWrite, "LcdWrite"); //ADD Here!!
    

    printf("EthernetInterface Setting up...\r\n");
    if(eth.init()!=0) 
    {                             //for DHCP Server
        //if(eth.init(IPAddress,NetMasks,Gateway)!=0) { //for Static IP Address
        printf("EthernetInterface Initialize Error \r\n");
        return -1;
    }
    if(eth.connect()!=0) 
    {
        printf("EthernetInterface Connect Error \r\n");
        return -1;
    }
    printf("IP Address is %s\r\n", eth.getIPAddress());
    printf("NetMask is %s\r\n", eth.getNetworkMask());
    printf("Gateway Address is %s\r\n", eth.getGateway());
    printf("Ethernet Setup OK\r\n");

    printf("\nList all directories/files /local.\n");
    do_list("/local");

    //HTTPServerAddHandler<SimpleHandler>("/hello"); //Default handler
    HTTPServerAddHandler<AnalogInHandler>("/analogIn"); //Default handler    
    //FSHandler::mount("/local", "/");
    //HTTPServerAddHandler<FSHandler>("/");
    HTTPServerAddHandler<RPCHandler>("/rpc");
    HTTPServerStart(80);
}

void LcdWrite(Arguments* arg, Reply* r)  //ADD Here!!
{
    printf("%s",arg->argv[0]);
}
