/** Beispiel fuer Verwendung der HTTP Methoden (GET, POST, PUT, DELETE)
 *
 * Braucht ein Board mit Ethernet
 */
#include "mbed.h"
#include "HTTPClient.h"
#include "HTTPText.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);

EthernetInterface eth;
HTTPClient http;
char message[6000];
char str[512];

DigitalOut myled(LED1);

int main()
{
    pc.baud(9600);
    printf("HTTP Client - Build " __DATE__ " - " __TIME__ "\r\n");
    eth.init();
    eth.connect();

    while(1) 
    {
        myled = 1;
        printf( "GET http://developer.mbed.org/media/uploads/mbed_official/hello.txt\n" );
        //int ret = http.get("https://raw.githubusercontent.com/mc-b/microHOME/master/README.md", message, sizeof(message));
        int ret = http.get("http://developer.mbed.org/media/uploads/mbed_official/hello.txt", message, sizeof(message));
        if ( !ret ) 
        {
            printf("Success - read %d characters.\r\n", strlen(message));
            printf("%s\r\n", message);
        }
        else
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        
        myled = 0;

        //POST data
        HTTPMap map;
        HTTPText inText(str, 512);
        map.put("Hello", "World");
        map.put("test", "1234");
        printf("\nTrying to post data...\n");
        ret = http.post("http://httpbin.org/post", map, &inText);
        if ( ! ret ) 
        {
            printf("Executed POST successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } 
        else 
        {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }

        //PUT data
        strcpy(str, "This is a PUT test!");
        HTTPText outText(str);
        //HTTPText inText(str, 512);
        printf("\nTrying to put resource...\n");
        ret = http.put("http://httpbin.org/put", outText, &inText);
        if (!ret) {
            printf("Executed PUT successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }

        //DELETE data
        //HTTPText inText(str, 512);
        printf("\nTrying to delete resource...\n");
        ret = http.del("http://httpbin.org/delete", &inText);
        if (!ret) {
            printf("Executed DELETE successfully - read %d characters\n", strlen(str));
            printf("Result: %s\n", str);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }

        wait(10);
    }
    // eth.disconnect();
}
