// Read from I2C slave at address 0x62

#include "mbed.h"
#include "MPU6050.h"

Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
MPU6050 Wire(PB_9 , PB_8); 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3);    //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);           //Chip Select para el controlador.
//Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
Serial com_tar(PC_10,PC_11);        //master f446R
//Serial com_tar(PA_15,PB_7);       //slave f411R        //habilitar la comunicacion serial a traves del puerto usb.
Ticker timer, timer_1;
DigitalIn pulsador(PH_1);
AnalogIn in1(PC_2);
AnalogIn in2(PC_3);
DigitalOut led(LED1);

#define  VEL 400                     //Velocidad de actualizacion de dato en el controlador.
#define  MIN 1
#define  MAX 8
#define  MINC 128
#define  MAXC 1
#define  DEL 0.1
#define  GIRO 3
#define  G_DIAG 3

int columna=1, manzanas=0, fila=1, fil=1, colum=0;
uint8_t _guarda_manzanas[8]={0,0,0,0,0,0,0,0};
uint8_t mat_act[11]={0,0,0,0,0,0,0,0,0,0,0};    //Matriz para mostrar en pantalla.
uint8_t mat_tmp1[8]={0,0,0,0,0,0,0,0};
uint8_t cont=0, correr=0, metrix=0,type_fig=0,reset=0;
uint8_t ncolumna=1,grados=1,ficha=0;
uint8_t mat_tmp[8]={0,0,0,0,0,0,0,0};           //Matriz temporal para arrojar las fichas.
                    //   0     ,   1      ,   2      ,  3       ,    4     ,5,   6
uint8_t FIG_ALL[8]={0b10000000,0b11000000,0b11100000,0b01000000,0b01100000,0,0b00100000};//FIG_C[0]=1; FIG_C[1]=11; FIG_C[2]=111; FIG_C[3]=01; FIG_C[4]=011

bool _boton=0;
void blink();
void boton();
void guarda_manzana();
void imprime_manzanas();
void cop_mat(uint8_t,uint8_t,uint8_t,uint8_t);
void borrar();
void dibujar();
void buscar_fil();
void guardar_mat();
void correr_fig();
void imp_mat();
void fichas();
void buscar_linea();
void revisar_mov();
void manzanas_revisar_mov();
void cambiar_jugador();
void sendSPI(uint8_t, uint8_t);
void buscador();
int main ();

//--------------------------------------------------
//-------------------BUSCAR_FILA------------------------
//--------------------------------------------------
void buscar_fil(){
    for (uint8_t i=0;i<9;i++){                     
        if((mat_act[i]& mat_tmp[3])==0){
        fila=i;
        //command.printf("\n1- comparacion inicial:\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[3])!=0){
        fila=i-1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n2- comparacion mat_act[i]& mat_tmp[2] :\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[2])!=0){            //se condicionan las salidas de la busqueda de lanueva fila
        fila=i;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n3- comparacion mat_act[i]& mat_tmp[1] :\n %d",mat_act[i]& mat_tmp[1]);
        }
        if((mat_act[i]& mat_tmp[1])!=0){
        fila=i+1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n4- comparacion mat_act[i]& mat_tmp[0]:\n %d",mat_act[i]& mat_tmp[0]);
        }
    }
    if(fila>8)
        fila=8;
    if(fila<=1){
        wait_ms(VEL);
        borrar();
        fila=8;
    }
    command.printf("\n buscar fila \n %d",fila);
    command.printf("\n ******************************* \n ");
};


//--------------------------------------------------
//-------------------GUARDAR_MATRIZ------------------------
//--------------------------------------------------
void guardar_mat(){
        for (uint8_t i=0;i<9;i++){
            mat_act[fila-(8-i)]=mat_tmp1[i];
            }
        };


//--------------------------------------------------
//-------------------CORRER_FIGURA------------------------
//--------------------------------------------------        
void correr_fig(){
    
    uint8_t correr=command.getc();
    
    if(correr==30)  //Arriba, voltear figura.
    correr=1;
    
    else if(correr==29)  //izquierda, correr la figura.
    correr=2;
    
    else if(correr==28)  //Derecha correr la figura.
    correr=3;
    
    else if(correr==31)  //bajar, baja la figura.
    correr=0;
    command.printf("\n correr fig \n %d",correr);
    revisar_mov();
    }


//--------------------------------------------------
//-------------------IMPRIMIR_MATRIZ------------------------
//--------------------------------------------------    
void imp_mat(){                                 //se genera la variable global cont.
            mat_tmp1[0]=(mat_tmp[0]+ mat_act[cont-3]);
            mat_tmp1[1]=(mat_tmp[1]+ mat_act[cont-2]);
            mat_tmp1[2]=(mat_tmp[2]+ mat_act[cont-1]);
            mat_tmp1[3]=(mat_tmp[3]+ mat_act[cont]);         //condicionador de funcion, se descarta por una funcion smart.                     
            sendSPI(cont-3,mat_tmp1[0]);
            sendSPI(cont-2,mat_tmp1[1]);
            sendSPI(cont-1,mat_tmp1[2]);
            sendSPI(cont  ,mat_tmp1[3]);                     //pasa de i+2 a i+1
            wait_ms(VEL);
}


//--------------------------------------------------
//-------------------DIBUJAR_FICHAS------------------------
//--------------------------------------------------
void dibujar()
{    
    switch (ficha){                  //Se envia el vector que contiene la figura a la funcion copiar matriz.
        case 1: if(ncolumna>7)
                ncolumna=7;
                cop_mat(5,1,1,ncolumna); 
                break;  //1: cuadro;
        
        case 2: if(grados==1 || grados==3)              
                cop_mat(0,0,0,ncolumna);
                if(grados==2 || grados==4)
                cop_mat(5,5,2,ncolumna);         //2: I;    
                break;
                  
        case 3: if(grados==1)
                cop_mat(0,0,1,ncolumna);         //3: L; 
                if(grados==2)
                cop_mat(5,2,0,ncolumna);
                if(grados==3)
                cop_mat(1,3,3,ncolumna);
                if(grados==4)
                cop_mat(5,6,2,ncolumna);
                break;
        
        case 4: if(grados==1)
                cop_mat(5,3,2,ncolumna);         //4: T;
                if(grados==2)
                cop_mat(0,1,0,ncolumna);
                if(grados==3)
                cop_mat(5,2,3,ncolumna);
                if(grados==4)
                cop_mat(3,1,3,ncolumna);
                break;
        
        case 5: if(grados==1 || grados==3)
                cop_mat(5,4,1,ncolumna);   //5: S; 
                if(grados==2 || grados==4)
                cop_mat(0,1,3,ncolumna);
                break;      
    }  
}


//--------------------------------------------------
//-------------------FICHAS_RANDOM------------------------
//--------------------------------------------------
void fichas(){
    ficha= rand() % 5; 
    }


//--------------------------------------------------
//-------------------BUSCAR_LINEA------------------------
//--------------------------------------------------    
void buscar_linea(){
    for(uint8_t i=0;i<9;i++){
        if(mat_act[i]==255){
            for(uint8_t a=i;a>=1;a--){
                sendSPI(a,mat_act[a-1]);
                mat_act[a]=mat_act[a-1];
            }
        }
    }
}


//--------------------------------------------------
//-------------------REVISAR_MOVIMIENTO------------------------
//--------------------------------------------------
void revisar_mov(){
    command.printf("\n correr:\n %d",correr);
    switch (correr){
                
                case 0:
                cont++;
                if(cont>8)cont=8;
                break;                                                    //cae la figura;
                
                case 1:
                if((mat_tmp[1]==2) || (mat_tmp[1]==1) || (mat_tmp[1]==3)) //faltan condiciones para evitar desplazamiento innecesario.
                ncolumna--;
                grados++;
                if(grados>4)
                grados=1;
                break;                                                    //Girar la figura;
                
                case 2:
                if((mat_tmp[1]!=1) && (mat_tmp[2]!=1) && (mat_tmp[3]!=1)){
                    if((mat_tmp[1]!=3) && (mat_tmp[2]!=3) && (mat_tmp[3]!=3)){
                        if((mat_tmp[1]!=7) && (mat_tmp[2]!=7) && (mat_tmp[3]!=7))
                        ncolumna++;
                        }
                    }
                command.printf("\n columna:\n %d",ncolumna);
               
                break;                                                    //correr a la Derecha;
                
                case 3:
                ncolumna--;
                command.printf("\n columna:\n %d",ncolumna);
                if(ncolumna<1)
                ncolumna=1;
                break;                                                    //correr a la izquierda;
                /*
                case 4:
                cont++;
                if(cont>8)cont=8;
                break; 
                */
            }  
    } 


//--------------------------------------------------
//-------------------ESCOGER_JUEGO------------------------
//--------------------------------------------------   
int escoger_juego(){
    uint8_t escoger=0;
    float _acc[3];
    int acc[3],buscado=32;  
    while(escoger==0)
    {
        ncolumna=3;
        cont=3;
        ficha=4;
        dibujar();
        imp_mat();
        guardar_mat();
        //////////////////
        sendSPI(7,36);
        //wait(0.5);
        if(_boton==1) 
            {
                Wire.getAccelero(_acc);
                acc[0]=((int)_acc[0])+2;
                acc[1]=((int)_acc[1])+2; 
            }
        else
            {
                int x=((int)(in1.read()*-650))+13;
                int y=((int)(in2.read()*-650))+13;
                acc[0]=x;
                acc[1]=y;
                //command.printf("Joystick: \t X= %d, \t Y= %d, \n", x,y);     
            }
        if(acc[0]>GIRO)            //eje x derecha
            {
                correr=30;
                command.printf("\nJoystick: correr= %d, \n", correr);
            }          
        else if(acc[0]<-GIRO)   //eje x izquierda
            {
                        correr=31;
                command.printf("\nJoystick: correr= %d, \n", correr);
            }
        if(correr==30)
            {
                grados= rand() % 4;
                ficha= rand() % 5;
                ncolumna=ncolumna++;
                cont=3;
                dibujar();
                imp_mat();
                guardar_mat();
                sendSPI(0,0);
                sendSPI(1,0);
                sendSPI(2,0);
                sendSPI(3,0);
                wait(0.1);
                if(_boton==1)
                escoger=1;
                command.printf("\nTetris: escoger= %d, \n", escoger); 
            }
        else if(correr==31)
            {
                sendSPI(7,4+buscado);
                wait(0.05);
                sendSPI(7,buscado);
                buscado=buscado>>1;
                if(buscado==4)
                buscado=32;
                if(_boton==1)
                escoger=2;
                command.printf("\nRecoge_manzanas: escoger= %d, \n", escoger); 
            }
    }
    return escoger;
}

//--------------------------------------------------
//-------------------COPIAR_MATRIZ------------------------
//--------------------------------------------------
void cop_mat(uint8_t a,uint8_t b,uint8_t c,uint8_t columna)
{       
        if(((mat_act[cont-2]& FIG_ALL[c]>>columna-1)==0)&&((mat_act[cont-1]& FIG_ALL[b]>>columna-1)==0)&&((mat_act[cont]& FIG_ALL[a]>>columna-1)==0)){
                    mat_tmp[0]= FIG_ALL[5]>>columna-1;             
                    mat_tmp[1]= FIG_ALL[a]>>columna-1;            //Realiza una copia de la matriz actual fila por fila.
                    mat_tmp[2]= FIG_ALL[b]>>columna-1;
                    mat_tmp[3]= FIG_ALL[c]>>columna-1;
        }   
}

//--------------------------------------------------
//-------------------GUARDA_MANZANAS------------------------
//-------------------------------------------------- 
void guarda_manzana()
{
       _guarda_manzanas[fil]=_guarda_manzanas[fil]+colum; 
}

//--------------------------------------------------
//-------------------TICKER------------------------
//--------------------------------------------------  
void attime() 
{
    //blink();
    boton();
};
 
//--------------------------------------------------
//-------------------TICKER_TETRIS------------------------
//--------------------------------------------------  
void attime_tetris() 
{
    //blink();
    cont++;
}; 

//--------------------------------------------------
//-------------------BOTON------------------------
//--------------------------------------------------  
void boton()
{
    uint8_t a=0;
    if(reset==1)
    reset=0;
    while (pulsador == 0) 
        {
            command.printf("Button pressed %d\n", a);
            a++;
            if (a>20)
            {
                for(int i=0;i<9;i++)
                {
                    borrar();
                    wait(0.1);
                    sendSPI(4,24);
                    sendSPI(5,24);
                    wait(0.1);
                }
                reset=1;
            }
            
            _boton= !_boton;
        }
}  

//--------------------------------------------------
//-------------------SPI------------------------
//--------------------------------------------------   
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
};

//--------------------------------------------------
//-------------------TEST------------------------
//--------------------------------------------------   
void test()                 //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x9);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

//--------------------------------------------------
//-------------------BORRAR------------------------
//--------------------------------------------------   
void borrar()            //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
    }
}

//--------------------------------------------------
//-------------------IMPRIME_MANZANAS------------------------
//--------------------------------------------------  
void imprime_manzanas()
{
    for(int i=0;i<9;i++)
    {
        if(i==fila)
        {
            uint8_t x=_guarda_manzanas[i]+columna;
            sendSPI(i,x);
            command.printf("if=fila.imprime_manzanas: X=%d\n", x);
        }  
        else
        {
            sendSPI(i,_guarda_manzanas[i]);
            command.printf("else.imprime_manzanas: %d\n", _guarda_manzanas[i]);
        }
    }
}

//--------------------------------------------------
//-------------------GENERAR_PUNTO------------------------
//--------------------------------------------------   
void generar_punto()
{
    int col[8]={1,2,4,8,16,32,64,128};
    borrar();
    int _fil=fil;
    fil= rand() % 7+1;
    int y= rand() % 7+1;
        command.printf("\n\n Fila: %d",fil); 
    command.printf("\n Columna:%d",col[y]);
    if(_fil==fil)
        colum=colum+col[y];
    colum=col[y];
    if(fil==fila)
    {
        int guarda_linea=columna+colum;
        sendSPI(fila,guarda_linea);
    }
    else
    sendSPI(fil,col[y]);
}

//--------------------------------------------------
//-------------------BLINK------------------------
//--------------------------------------------------  
void blink()
{
    borrar();
    sendSPI(fila,columna);
    wait(0.05);
}

//--------------------------------------------------
//-------------------MANZANAS_REVISAR_MOV------------------------
//--------------------------------------------------   
void manzanas_revisar_mov(){
    //uint8_t guardar_linea=0;
    switch (correr)
    {
        
        case 2:
                columna=columna<<1;
                fila--;
                if (columna>MINC)
                    columna=MAXC;
                if (fila<MIN)
                {
                    fila=MAX;
                    sendSPI(MIN,0);
                }
                sendSPI(fila+1,_guarda_manzanas[fila+1]);
        break;
        
        case 4:
                columna=columna<<1;
                fila++;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                if (columna>MINC)
                    columna=MAXC;
                sendSPI(fila-1,_guarda_manzanas[fila-1]);
        break;
        
        case 1:
                columna=columna>>1;
                fila--;
                if (columna<MAXC)
                    columna=MINC;
                if (fila<MIN){
                    fila=MAX;
                    sendSPI(MIN,0);
                    }
                sendSPI(fila+1,_guarda_manzanas[fila+1]);
        break;
        
        case 3:
                columna=columna>>1;
                fila++;
                if (columna<MAXC)
                    columna=MINC;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                sendSPI(fila-1,_guarda_manzanas[fila-1]);
        break;
        
        case 28:
                columna=columna<<1;
                if (columna>MINC)
                    columna=MAXC;
        break;
        
        case 29:
                columna=columna>>1;
                if (columna<MAXC)
                    columna=MINC;
        break;
        
        case 30:
                fila--;
                if (fila<MIN){
                    fila=MAX;
                    sendSPI(MIN,0);
                    }
                sendSPI(fila+1,_guarda_manzanas[fila+1]);
        break;
        
        case 31:
                fila++;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                sendSPI(fila-1,_guarda_manzanas[fila-1]);
        break;  
        
        case 0:
        break; 
        }
    }
    
//--------------------------------------------------
//-------------------VELOCIDAD-----------------------
//-------------------------------------------------- 
int velocidad(float _acc[3])
{
    int vel=0,x=2,y=4; //
    int acc[3];
        acc[0]=(int)_acc[0];
        acc[1]=(int)_acc[1];
       if((acc[0]>GIRO) || (acc[0]<-GIRO) || (acc[1]>GIRO) || (acc[1]<-GIRO))
        {
                if((acc[0]>(GIRO+x)) || (acc[0]<-(GIRO+x)) || (acc[1]>(GIRO+x)) || (acc[1]<-(GIRO+x)))
                    {
                        vel=VEL/2; 
                        if((acc[0]>(GIRO+y)) || (acc[0]<-(GIRO+y)) || (acc[1]>(GIRO+y)) || (acc[1]<-(GIRO+y)))
                            vel=VEL;
                    }
                else
                    vel=VEL/3;   
        }
    return vel;
}
    
//--------------------------------------------------
//-------------------BUSCADOR------------------------
//--------------------------------------------------   
    //command.printf("Accelerometer: \t X= %f, \t Y= %f, \t Z=%f \n", acc[0],acc[1],acc[2]);
    //command.printf("Gyroscope: \t X= %f, \t Y= %f, \t Z=%f \n", gyro[0],gyro[1],gyro[2]);
    //float gyro[3]; Wire.getGyro(gyro);
    //command.printf("Accelerometer: \t X= %d, \t Y= %d, \n", acc[0],acc[1]);  
    
void buscador()
{
    //uint8_t correr;
    int y=0,x=0,acc[3],v;
    float _acc[3];     

        if(_boton==1) 
        {
            Wire.getAccelero(_acc);
            acc[0]=((int)_acc[0])+2;
            acc[1]=((int)_acc[1])+2; 
        }
        else
        {
            x=((int)(in1.read()*-650))+13;
            y=((int)(in2.read()*-650))+13;
            acc[0]=x;
            acc[1]=y;
            //command.printf("Joystick: \t X= %d, \t Y= %d, \n", x,y);     
        }
        
        //command.printf("Velocidad %d \n", v);
        if(acc[0]>GIRO)            //eje x derecha
        {
            if(acc[1]>G_DIAG)      //eje y arriba
            correr=1;
            else if(acc[1]<-G_DIAG)//eje y abajo
            correr=2;
            else
            correr=30;
        }          
        else if(acc[0]<-GIRO)   //eje x izquierda
        {
            if(acc[1]>G_DIAG)     //eje y arriba
                    correr=3;
                    else if(acc[1]<-G_DIAG)//eje y abajo
                    correr=4;
                    else
                    correr=31;
        }           
        else if(acc[1]>GIRO)    //eje y arriba
                    correr=29;
        else if(acc[1]<-GIRO)   //eje y abajo
                    correr=28;
        else
        correr=0;
        manzanas_revisar_mov();        
        v=velocidad(_acc);
        wait_ms(v);
}

//--------------------------------------------------
//-------------------COMER------------------------
//--------------------------------------------------   
int comer ()
{
            int x=0;
            if((fil==fila)&&((colum & columna) != 0))
            {
            manzanas++;
            sendSPI(fila,columna);
                        for(int i=0;i<manzanas;i++)
                        {
                            int guarda_linea=columna+colum;
                            sendSPI(fila,guarda_linea);
                            generar_punto();
                            sendSPI(fil,colum);
                            //com_tar.putc(x);
                        }
                        x=1;
            }
                return x;
}


//--------------------------------------------------
//-------------------VALIDAR_CONTRINCANTE------------------------
//--------------------------------------------------   
int validar_contrincante(){
    int x=com_tar.getc();
    return x;
    }


//--------------------------------------------------
//-------------------MAIN------------------------
//--------------------------------------------------   
int main ()
{
    int guarda_linea,x=0;
    timer.attach(&attime, 0.3);
    timer_1.attach(&attime_tetris, 0.4);
    test();
    while(1)
    {
        borrar();
        int juego=escoger_juego();
        if(juego==1)
        {
            while(reset==0)
            {
                //cambiar_jugador(); 
                    fichas();
                    buscar_fil();
                    cont=0;
                    // correr=command.getc();     //recibe el comando para orientar la ficha.
                    while (cont<fila)
                    {
                            //cambiar_jugador(); 
                            correr_fig();
                            dibujar();
                            buscar_fil();
                            imp_mat();
                            wait_ms(VEL);
                    }       
                    guardar_mat();
                    buscar_linea(); 
            } //fin while
        }
        else if(juego==2)
        {
            sendSPI(fila,columna);
            generar_punto();
            while(reset==0)
            {
                buscador();
                //validar_contrincante();
                    x=comer();
                    //command.printf("\n comer:\n %d",x);
                    if (x==0)
                    {
                        if(fil==fila)
                        {
                                guarda_linea=columna+colum;
                                sendSPI(fila,guarda_linea);
                        }
                        else
                        {
                                guarda_linea=columna;
                                sendSPI(fila,guarda_linea);
                                sendSPI(fil,colum);  
                        }
                    }
                    else
                    {
                        sendSPI(fila,columna);
                    }
                //generar_punto();
            }
        }
    }
}