// Read from I2C slave at address 0x62

#include "mbed.h"

#include "MPU6050.h"

Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
MPU6050 Wire(PB_9 , PB_8 ); 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3);    //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);           //Chip Select para el controlador.
//Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
Serial com_tar(PC_10,PC_11);        //master f446R
//Serial com_tar(PA_15,PB_7);       //slave f411R        //habilitar la comunicacion serial a traves del puerto usb.
Ticker timer;
DigitalIn pulsador(PH_1);
AnalogIn in1(PC_2);
AnalogIn in2(PC_3);
DigitalOut led(LED1);

#define  VEL 200                     //Velocidad de actualizacion de dato en el controlador.
#define  MIN 1
#define  MAX 8
#define  MINC 128
#define  MAXC 1
#define  DEL 0.1
#define  GIRO 3
#define  G_DIAG 3

int columna=1, manzanas=0, fila=1, fil=1, colum=0;
uint8_t _guarda_manzanas[8]={0,0,0,0,0,0,0,0};
bool _boton=0;
void blink();
void boton();
void guarda_manzana();
void imprime_manzanas();

//--------------------------------------------------
//-------------------GUARDA_MANZANAS------------------------
//-------------------------------------------------- 
void guarda_manzana()
{
       _guarda_manzanas[fil]=_guarda_manzanas[fil]+colum; 
}

//--------------------------------------------------
//-------------------TICKER------------------------
//--------------------------------------------------  
void attime() {
    blink();
    boton();
    }; 

//--------------------------------------------------
//-------------------BOTON------------------------
//--------------------------------------------------  
void boton()
{
    if (pulsador == 0) 
        {
            command.printf("Button pressed %b\n", _boton);
            _boton= !_boton;
        }
}  

//--------------------------------------------------
//-------------------SPI------------------------
//--------------------------------------------------   
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
};

//--------------------------------------------------
//-------------------TEST------------------------
//--------------------------------------------------   
void test()                 //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x9);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

//--------------------------------------------------
//-------------------BORRAR------------------------
//--------------------------------------------------   
void borrar()            //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
    }
}

//--------------------------------------------------
//-------------------IMPRIME_MANZANAS------------------------
//--------------------------------------------------  
void imprime_manzanas()
{
    for(int i=0;i<9;i++)
    {
        if(i==fila)
        {
            uint8_t x=_guarda_manzanas[i]+columna;
            sendSPI(i,x);
            command.printf("if=fila.imprime_manzanas: X=%d\n", x);
        }  
        else
        {
            sendSPI(i,_guarda_manzanas[i]);
            command.printf("else.imprime_manzanas: %d\n", _guarda_manzanas[i]);
        }
    }
}

//--------------------------------------------------
//-------------------GENERAR_PUNTO------------------------
//--------------------------------------------------   
void generar_punto()
{
    int col[8]={1,2,4,8,16,32,64,128};
    int _fil=fil;
    fil= rand() % 7+1;
    int y= rand() % 7+1;
    int colum=col[y];
    if(_fil==fil)
        _guarda_manzanas[fil]=colum+_guarda_manzanas[fil];
    else
        _guarda_manzanas[fil]=colum;
    command.printf("Generar_punto: %d\n", _guarda_manzanas[fil]);
    imprime_manzanas();
}

//--------------------------------------------------
//-------------------BLINK------------------------
//--------------------------------------------------  
void blink()
{
    borrar();
    sendSPI(fila,columna);
    wait(0.05);
}

//--------------------------------------------------
//-------------------REVISAR_MOV------------------------
//--------------------------------------------------   
void revisar_mov(uint8_t correr){
    //uint8_t guardar_linea=0;
    switch (correr)
    {
        
        case 2:
                columna=columna<<1;
                fila--;
                if (columna>MINC)
                    columna=MAXC;
                if (fila<MIN)
                {
                    fila=MAX;
                    uint8_t x=_guarda_manzanas[MIN];
                    sendSPI(MIN,0);
                }
                sendSPI(fila+1,0);
        break;
        
        case 4:
                columna=columna<<1;
                fila++;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                if (columna>MINC)
                    columna=MAXC;
                sendSPI(fila-1,0);
        break;
        
        case 1:
                columna=columna>>1;
                fila--;
                if (columna<MAXC)
                    columna=MINC;
                if (fila<MIN){
                    fila=MAX;
                    sendSPI(MIN,0);
                    }
                sendSPI(fila+1,0);
        break;
        
        case 3:
                columna=columna>>1;
                fila++;
                if (columna<MAXC)
                    columna=MINC;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                sendSPI(fila-1,0);
        break;
        
        case 28:
                columna=columna<<1;
                if (columna>MINC)
                    columna=MAXC;
        break;
        
        case 29:
                columna=columna>>1;
                if (columna<MAXC)
                    columna=MINC;
        break;
        
        case 30:
                fila--;
                if (fila<MIN){
                    fila=MAX;
                    sendSPI(MIN,0);
                    }
                sendSPI(fila+1,0);
        break;
        
        case 31:
                fila++;
                if (fila>MAX){
                    fila=MIN;
                    sendSPI(MAX,0);
                    }
                sendSPI(fila-1,0);
        break;  
        
        case 0:
        break; 
        }
    }
    
//--------------------------------------------------
//-------------------VELOCIDAD-----------------------
//-------------------------------------------------- 
int velocidad(float _acc[3])
{
    int vel=0,x=2,y=4; //
    int acc[3];
        acc[0]=(int)_acc[0];
        acc[1]=(int)_acc[1];
       if((acc[0]>GIRO) || (acc[0]<-GIRO) || (acc[1]>GIRO) || (acc[1]<-GIRO))
        {
                if((acc[0]>(GIRO+x)) || (acc[0]<-(GIRO+x)) || (acc[1]>(GIRO+x)) || (acc[1]<-(GIRO+x)))
                    {
                        vel=300; 
                        if((acc[0]>(GIRO+y)) || (acc[0]<-(GIRO+y)) || (acc[1]>(GIRO+y)) || (acc[1]<-(GIRO+y)))
                            vel=100;
                    }
                else
                    vel=500;   
        }
    return vel;
}
    
//--------------------------------------------------
//-------------------BUSCADOR------------------------
//--------------------------------------------------   
    //command.printf("Accelerometer: \t X= %f, \t Y= %f, \t Z=%f \n", acc[0],acc[1],acc[2]);
    //command.printf("Gyroscope: \t X= %f, \t Y= %f, \t Z=%f \n", gyro[0],gyro[1],gyro[2]);
    //float gyro[3]; Wire.getGyro(gyro);
    //command.printf("Accelerometer: \t X= %d, \t Y= %d, \n", acc[0],acc[1]);  
    
void buscador()
{
    uint8_t correr;
    int y=0,x=0,acc[3],v;
    float _acc[3];     

        if(_boton==1) 
        {
            Wire.getAccelero(_acc);
            acc[0]=((int)_acc[0])+2;
            acc[1]=((int)_acc[1])+2; 
        }
        else
        {
            x=((int)(in1.read()*-650))+13;
            y=((int)(in2.read()*-650))+13;
            acc[0]=x;
            acc[1]=y;
            //command.printf("Joystick: \t X= %d, \t Y= %d, \n", x,y);     
        }
        
        //command.printf("Velocidad %d \n", v);
        if(acc[0]>GIRO)            //eje x derecha
        {
            if(acc[1]>G_DIAG)      //eje y arriba
            correr=1;
            else if(acc[1]<-G_DIAG)//eje y abajo
            correr=2;
            else
            correr=30;
        }          
        else if(acc[0]<-GIRO)   //eje x izquierda
        {
            if(acc[1]>G_DIAG)     //eje y arriba
                    correr=3;
                    else if(acc[1]<-G_DIAG)//eje y abajo
                    correr=4;
                    else
                    correr=31;
        }           
        else if(acc[1]>GIRO)    //eje y arriba
                    correr=29;
        else if(acc[1]<-GIRO)   //eje y abajo
                    correr=28;
        else
        correr=0;
        revisar_mov(correr);        
        v=velocidad(_acc);
        wait_ms(v);
}


//--------------------------------------------------
//-------------------COMER------------------------
//--------------------------------------------------   
int comer ()
{
            int x=0;
            if((fil==fila)&&((colum & columna) != 0))
            {
            manzanas++;
            sendSPI(fila,columna);
                        for(int i=0;i<manzanas;i++)
                        {
                            int guarda_linea=columna+colum;
                            sendSPI(fila,guarda_linea);
                            generar_punto();
                            sendSPI(fil,colum);
                            //com_tar.putc(x);
                        }
                        x=1;
            }
                return x;
}


//--------------------------------------------------
//-------------------VALIDAR_CONTRINCANTE------------------------
//--------------------------------------------------   
int validar_contrincante(){
    int x=com_tar.getc();
    return x;
    }


//--------------------------------------------------
//-------------------MAIN------------------------
//--------------------------------------------------   
int main ()
{
    int guarda_linea,x=0;
    timer.attach(&attime, 0.3);
    test();
    borrar();
    sendSPI(fila,columna);
    generar_punto();
    while(1)
        {
        buscador();
        //validar_contrincante();
            x=comer();
            //command.printf("\n comer:\n %d",x);
            if (x==0)
                {
                if(fil==fila){
                        guarda_linea=columna+colum;
                        sendSPI(fila,guarda_linea);
                        }
                else
                    {
                        guarda_linea=columna;
                        sendSPI(fila,guarda_linea);
                        sendSPI(fil,colum);  
                    }
                }
            else{
                sendSPI(fila,columna);
                }
        //generar_punto();
        }
}