// Read from I2C slave at address 0x62

#include "mbed.h"

#include "MPU6050.h"

Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
MPU6050 Wire(PB_9 , PB_8 ); 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3);    //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);           //Chip Select para el controlador.
//Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
Serial com_tar(PC_10,PC_11);        //master f446R
//Serial com_tar(PA_15,PB_7);       //slave f411R        //habilitar la comunicacion serial a traves del puerto usb.
Ticker timer;

#define  VEL 200                     //Velocidad de actualizacion de dato en el controlador.
#define  MIN 1
#define  MAX 8
#define  MINC 128
#define  MAXC 1
#define  DEL 0.1
#define  GIRO 2
#define  G_DIAG 2

int columna=1,manzanas=0;
int fila=1, fil=1, colum=1;
void blink();

//--------------------------------------------------
//-------------------TICKER------------------------
//--------------------------------------------------  
void attime() {
    blink();
    }; 
    
//--------------------------------------------------
//-------------------SPI------------------------
//--------------------------------------------------   
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
};


//--------------------------------------------------
//-------------------TEST------------------------
//--------------------------------------------------   
void test()                 //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x00);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}


//--------------------------------------------------
//-------------------BORRAR------------------------
//--------------------------------------------------   
void borrar()            //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
    }
}


//--------------------------------------------------
//-------------------GENERAR_PUNTO------------------------
//--------------------------------------------------   
void generar_punto()
{
    int col[8]={1,2,4,8,16,32,64,128};
    //int fil=0;
    borrar();
    int _fil=fil;
    fil= rand() % 7+1;
    int y= rand() % 7+1;
    command.printf("\n\n Fila: %d",fil); 
    command.printf("\n Columna:%d",col[y]);
    //int time=0;
    //while(time<4)
    //    {
    if(_fil==fil)
    colum=colum+col[y];
    colum=col[y];
    if(fil==fila){
                    int guarda_linea=columna+colum;
                    sendSPI(fila,guarda_linea);
                    }
    else
    sendSPI(fil,col[y]);
    
    //    wait_ms(VEL);
    //    sendSPI(fil,0);
    //    wait_ms(VEL);
    //    time++;
    //    }
    
}

//--------------------------------------------------
//-------------------BLINK------------------------
//--------------------------------------------------  
void blink(){
    sendSPI(fil,0);
        if(fil==fila)
                sendSPI(fila,columna);
    }

//--------------------------------------------------
//-------------------REVISAR_MOV------------------------
//--------------------------------------------------   
void revisar_mov(uint8_t correr){
    switch (correr){
        
        case 2:
        columna=columna<<1;
        fila--;
        if (columna>MINC)
            columna=MAXC;
        if (fila<MIN){
            fila=MAX;
            sendSPI(MIN,0);
            }
        sendSPI(fila+1,0);
        break;
        
        case 4:
        columna=columna<<1;
        fila++;
        if (fila>MAX){
            fila=MIN;
            sendSPI(MAX,0);
            }
        if (columna>MINC)
            columna=MAXC;
        sendSPI(fila-1,0);
        break;
        
        case 1:
        columna=columna>>1;
        fila--;
        if (columna<MAXC)
            columna=MINC;
        if (fila<MIN){
            fila=MAX;
            sendSPI(MIN,0);
            }
        sendSPI(fila+1,0);
        //command.printf("\n case1 Col:%d",columna);
        //command.printf("\n FIL:%d",fila);
        break;
        
        case 3:
        columna=columna>>1;
        fila++;
        if (columna<MAXC)
            columna=MINC;
        if (fila>MAX){
            fila=MIN;
            sendSPI(MAX,0);
            }
        sendSPI(fila-1,0);
        //command.printf("\n case3 Col:%d",columna);
        //command.printf("\n FIL:%d",fila);
        break;
        
        case 28:
        columna=columna<<1;
        if (columna>MINC)
            columna=MAXC;
        break;
        
        case 29:
        columna=columna>>1;
        if (columna<MAXC)
            columna=MINC;
        break;
        
        case 30:
        fila--;
        if (fila<MIN){
            fila=MAX;
            sendSPI(MIN,0);
            }
        sendSPI(fila+1,0);
        break;
        
        case 31:
        fila++;
        if (fila>MAX){
            fila=MIN;
            sendSPI(MAX,0);
            }
        sendSPI(fila-1,0);
        break;  
        
        case 0:
        break; 
        }
    }
    
//--------------------------------------------------
//-------------------VELOCIDAD-----------------------
//-------------------------------------------------- 
int velocidad(float _acc[3])
{
    uint8_t vel;
    int acc[3];
        acc[0]=_acc[0];
        acc[1]=_acc[1];
       if((acc[0]>GIRO) || (acc[0]<-GIRO) || (acc[1]>GIRO) || (acc[1]<-GIRO))
        {
                if(acc[0]>GIRO)
                    vel=acc[0];
                else if(acc[0]<-GIRO)
                    vel=-acc[0];
                else if(acc[1]>GIRO)
                    vel=acc[1];
                else if(acc[1]<-GIRO)
                    vel=-acc[1];
                command.printf("---Velocidad if %d \n", vel);     
         wait(3/vel);           
        }
    int v=1/vel;
    
    command.printf("Velocidad %d \n", v);    
    command.printf("x %d \n", acc[1]);
    command.printf("y %d \n", acc[0]);
    return vel;
}
    
//--------------------------------------------------
//-------------------BUSCADOR------------------------
//--------------------------------------------------   
void buscador()
{
    uint8_t correr;
    //float gyro[3]; Wire.getGyro(gyro);
    float acc[3]; Wire.getAccelero(acc);     
  //command.printf("Accelerometer: \t X= %f, \t Y= %f, \t Z=%f \n", acc[0],acc[1],acc[2]);
  //command.printf("Gyroscope: \t X= %f, \t Y= %f, \t Z=%f \n", gyro[0],gyro[1],gyro[2]);
        velocidad(acc);
        //command.printf("Velocidad %d \n", vel);
        if(acc[0]>GIRO)         //eje x derecha
        {
            if(acc[1]>G_DIAG)     //eje y arriba
            correr=1;
            else if(acc[1]<-G_DIAG)//eje y abajo
            correr=2;
            else
            correr=30;
            }          
    else if(acc[0]<-GIRO)   //eje x izquierda
        {
            if(acc[1]>G_DIAG)     //eje y arriba
                    correr=3;
                    else if(acc[1]<-G_DIAG)//eje y abajo
                    correr=4;
                    else
                    correr=31;
                    }           
    else if(acc[1]>GIRO)    //eje y arriba
                    correr=29;
    else if(acc[1]<-GIRO)   //eje y abajo
                    correr=28;
                else
                correr=0; //
        revisar_mov(correr);
        //wait (DEL);
    //command.printf("\n correr:\n %d",correr);    
}


//--------------------------------------------------
//-------------------COMER------------------------
//--------------------------------------------------   
int comer ()
{
            int x=0;
            if((fil==fila)&&((colum & columna) != 0))
            {
            manzanas++;
            sendSPI(fila,columna);
                        for(int i=0;i<manzanas;i++)
                        {
                            int guarda_linea=columna+colum;
                            sendSPI(fila,guarda_linea);
                            generar_punto();
                            sendSPI(fil,colum);
                            //com_tar.putc(x);
                        }
                        x=1;
            }
                return x;
}


//--------------------------------------------------
//-------------------VALIDAR_CONTRINCANTE------------------------
//--------------------------------------------------   
int validar_contrincante(){
    int x=com_tar.getc();
    return x;
    }

int main ()
{
    int guarda_linea,x=0;
    timer.attach(&attime, 0.3);
    test();
    borrar();
    sendSPI(fila,columna);
    generar_punto();
    while(1)
        {
        buscador();
        //validar_contrincante();
            x=comer();
            //command.printf("\n comer:\n %d",x);
            if (x==0)
                {
                if(fil==fila){
                        guarda_linea=columna+colum;
                        sendSPI(fila,guarda_linea);
                        }
                else
                    {
                        guarda_linea=columna;
                        sendSPI(fila,guarda_linea);
                        sendSPI(fil,colum);  
                    }
                }
            else{
                sendSPI(fila,columna);
                }
        //generar_punto();
        }
}