// Read from I2C slave at address 0x62

#include "mbed.h"

#include "MPU6050.h"

Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
MPU6050 Wire(PB_9 , PB_8 ); 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3);    //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);           //Chip Select para el controlador.
//Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
Serial com_tar(PC_10,PC_11);        //master f446R
//Serial com_tar(PA_15,PB_7);       //slave f411R        //habilitar la comunicacion serial a traves del puerto usb.

#define  VEL 200                     //Velocidad de actualizacion de dato en el controlador.
#define  MIN 1
#define  MAX 8
#define  MINC 128
#define  MAXC 1
#define  DEL 0.1

int columna=1;
int fila=1, fil=1, colum=1;

void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void test()                 //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x00);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

void borrar()            //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
    }
}

void generar_punto()
{
    int col[8]={0b00000001,0b00000010,0b00000100,0b00001000,0b00010000,0b00100000,0b01000000,0b10000000};
    //int fil=0;
    borrar();
    fil= rand() % 7+1; 
    int y= rand() % 7+1;
    command.printf("\n\n Fila: %d",fil); 
    command.printf("\n Columna:%d",col[y]);
    //int time=0;
    //while(time<4)
    //    {
    if(fil==fila){
                    int guarda_linea=columna+colum;
                    sendSPI(fila,guarda_linea);
                    }
    else
    sendSPI(fil,col[y]);
    colum=col[y];
    //    wait_ms(VEL);
    //    sendSPI(fil,0);
    //    wait_ms(VEL);
    //    time++;
    //    }
    
}

void revisar_mov(uint8_t correr){
    switch (correr){
        case 28:
        columna=columna<<1;
        if (columna>MINC)
            columna=MAXC;
        break;
        
        case 29:
        columna=columna>>1;
        if (columna<MAXC)
            columna=MINC;
        break;
        
        case 30:
        fila--;
        sendSPI(fila+1,0);
        if (fila<MIN)
            fila=MAX;
            sendSPI(fila+1,0);
        break;
        
        case 31:
        fila++;
        sendSPI(fila-1,0);
        if (fila>MAX)
            fila=MIN;
            sendSPI(fila-1,0);
        break;  
        
        case 0:
        fila;
        break; 
        }
    }

void buscador()
{

    uint8_t correr;
    //float gyro[3]; Wire.getGyro(gyro);
    float acc[3]; Wire.getAccelero(acc);     
    command.printf("Accelerometer: \t X= %f, \t Y= %f, \t Z=%f \n", acc[0],acc[1],acc[2]);
  //command.printf("Gyroscope: \t X= %f, \t Y= %f, \t Z=%f \n", gyro[0],gyro[1],gyro[2]);
 
    wait(DEL);

    int giro=3;
        if(acc[0]>giro)         //eje x derecha
            correr=29;          
        else if(acc[0]<-giro)   //eje x izquierda
            correr=28;          
        else if(acc[1]>giro)    //eje y arriba
            correr=30;
        else if(acc[1]<-giro)   //eje y abajo
            correr=31;
        else
        correr=0; //
        revisar_mov(correr);
        //wait (DEL);
    command.printf("\n correr:\n %d",correr);    
}

int comer ()
{
            int x=0;
            if(fil==fila){
                if((colum & columna) != 0)
                    {
                        generar_punto();
                        x=1;
                        sendSPI(fil,colum);
                        //com_tar.putc(x);
                        }
                }
                return x;
    }

int validar_contrincante(){
    int x=com_tar.getc();
    return x;
    }

int main ()
{
    int guarda_linea,x=0;
    test();
    borrar();
    sendSPI(fila,columna);
    generar_punto();
    while(1)
        {
        buscador();
        //validar_contrincante();
            x=comer();
            command.printf("\n comer:\n %d",x);
            if (x==0)
                {
                if(fil==fila){
                        guarda_linea=columna+colum;
                        sendSPI(fila,guarda_linea);
                        }
                else
                    {
                        guarda_linea=columna;
                        sendSPI(fila,guarda_linea);
                        sendSPI(fil,colum);  
                    }
                }
            else{
                sendSPI(fila,columna);
                }
        //generar_punto();
        }
}