#include "mbed.h"
#include "moggo.h" //agrega la libreria que contiene las figuras.
#include "MPU6050.h"

Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
MPU6050 Wire(PB_9 , PB_8 ); 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3);    //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);           //Chip Select para el controlador.
//Serial command(USBTX,USBRX);        //habilitar la comunicacion serial a traves del puerto usb.
Serial com_tar(PC_10,PC_11);        //master f446R
//Serial com_tar(PA_15,PB_7);       //slave f411R        //habilitar la comunicacion serial a traves del puerto usb.
Ticker timer;
DigitalIn pulsador(PH_1);
AnalogIn in1(PC_2);
AnalogIn in2(PC_3);

#define  VEL 120                //Velocidad de actualizacion de dato en el controlador.

uint8_t mat_act[11]={0,0,0,0,0,0,0,0,0,0,0};    //Matriz para mostrar en pantalla.
uint8_t mat_tmp[8]={0,0,0,0,0,0,0,0};           //Matriz temporal para arrojar las fichas.
uint8_t mat_tmp1[8]={0,0,0,0,0,0,0,0};
uint8_t cont=0,ncolumna=1,grados=1,ficha=0,GIRO=2,G_DIAG=2,correr=0,linea_spi=0;
int fila=0;
bool _boton=0;

void boton();
void sendSPI(uint8_t,uint8_t);
void borrar();

//--------------------------------------------------
//-------------------CARA_FELIZ------------------------
//--------------------------------------------------  
void cara_feliz()
{
    borrar();
    sendSPI(0x02,0b01100110);
    wait(0.2);
    sendSPI(0x03,0b01100110);
    wait(0.2); 
    sendSPI(0x06,0b01000010);   
    wait(0.2);
    sendSPI(0x07,0b00111100);
    wait(0.2);
        for(int i=0;i<4;i++)
        {
            sendSPI(0x06,0x00);
            sendSPI(0x07,0b00111100); 
            wait(0.2);   
            sendSPI(0x07,0b00111100);   
            wait(0.2);
            sendSPI(0x06,0b01000010);
            wait(0.2);
        }   
}

//--------------------------------------------------
//-------------------CARA_TRISTE------------------------
//--------------------------------------------------  
void cara_triste()
{
    borrar();
    sendSPI(0x02,0b01100110);
    wait(0.2);
    sendSPI(0x03,0b01100110);
    wait(0.2); 
    sendSPI(0x06,0b00111100);   
    wait(0.2);
    sendSPI(0x07,0b01000010);
    wait(0.2);
        for(int i=0;i<4;i++)
        {
            sendSPI(0x07,0x00);
            sendSPI(0x06,0b00111100); 
            wait(0.2);   
            sendSPI(0x06,0b00111100);   
            wait(0.2);
            sendSPI(0x07,0b01000010);
            wait(0.2);
        }        
}


void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void test()                 //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x00);     //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

void cop_mat(uint8_t a,uint8_t b,uint8_t c,uint8_t* fig,uint8_t columna)
{       
        if(((mat_act[cont-2]& (*(fig+c)>>columna-1))==0)&&((mat_act[cont-1]& (*(fig+b)>>columna-1))==0)&&((mat_act[cont]& (*(fig+a)>>columna-1))==0)){
                    mat_tmp[0]= *(fig+5)>>columna-1;             
                    mat_tmp[1]= *(fig+a)>>columna-1;            //Realiza una copia de la matriz actual fila por fila.
                    mat_tmp[2]= *(fig+b)>>columna-1;
                    mat_tmp[3]= *(fig+c)>>columna-1;
            }
}

void borrar()            //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
        mat_act[i]=0;    //Matriz para mostrar en pantalla.
    }
};

void buscar_fil(){
    for (uint8_t i=0;i<9;i++){                     
        if((mat_act[i]& mat_tmp[3])==0){
        fila=i;
        //command.printf("\n1- comparacion inicial:\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[3])!=0){
        fila=i-1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n2- comparacion mat_act[i]& mat_tmp[2] :\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[2])!=0){            //se condicionan las salidas de la busqueda de lanueva fila
        fila=i;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n3- comparacion mat_act[i]& mat_tmp[1] :\n %d",mat_act[i]& mat_tmp[1]);
        }
        if((mat_act[i]& mat_tmp[1])!=0){
        fila=i+1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n4- comparacion mat_act[i]& mat_tmp[0]:\n %d",mat_act[i]& mat_tmp[0]);
        }
    }
    if(fila>8)
        fila=8;
    if(fila<=0){
        wait_ms(VEL);
        borrar();
        fila=8;
    }
    //command.printf("\n buscar fila \n %d",fila);
    //command.printf("\n ******************************* \n ");
};

void guardar_mat(){
        mat_act[fila-3]=mat_tmp1[0];
        mat_act[fila-2]=mat_tmp1[1];
        mat_act[fila-1]=mat_tmp1[2];
        mat_act[fila  ]=mat_tmp1[3];
        };
        
void correr_fig(){
        
    //correr=command.getc();  
    int y=0,x=0,acc[3];
    //float gyro[3]; Wire.getGyro(gyro);
    float _acc[3];     
    //command.printf("Accelerometer: \t X= %f, \t Y= %f, \t Z=%f \n", acc[0],acc[1],acc[2]);
    //command.printf("Gyroscope: \t X= %f, \t Y= %f, \t Z=%f \n", gyro[0],gyro[1],gyro[2]);
       if(_boton==0) 
        {
            x=((int)(in1.read()*-650))+13;
            y=((int)(in2.read()*-650))+13;
            acc[0]=x;
            acc[1]=y;
            //command.printf("Joystick: \t X= %d, \t Y= %d, \n", x,y); 
        }
        else
        {
            Wire.getAccelero(_acc);
            acc[0]=(int)_acc[0];
            acc[1]=(int)_acc[1];
            //command.printf("Accelerometer: \t X= %d, \t Y= %d, \n", acc[0],acc[1]);     
        }
        if(acc[0]>GIRO)         //eje x derecha
            correr=1;          
        else if(acc[0]<-GIRO)   //eje x izquierda
            correr=0;          
        else if(acc[1]>GIRO)    //eje y arriba
            correr=2;
        else if(acc[1]<-GIRO)   //eje y abajo
            correr=3;
        else
        correr=0;
    
    
    switch (correr){
                
                case 0:
                cont++;
                if(cont>8)cont=8;
                break;                                                    //cae la figura;
                
                case 1:
                if((mat_tmp[1]==2) || (mat_tmp[1]==1) || (mat_tmp[1]==3)) //faltan condiciones para evitar desplazamiento innecesario.
                ncolumna--;
                grados++;
                if(grados>4)
                grados=1;
                break;                                                    //Girar la figura;
                
                case 2:
                if((mat_tmp[1]!=1) && (mat_tmp[2]!=1) && (mat_tmp[3]!=1)){
                    if((mat_tmp[1]!=3) && (mat_tmp[2]!=3) && (mat_tmp[3]!=3)){
                        if((mat_tmp[1]!=7) && (mat_tmp[2]!=7) && (mat_tmp[3]!=7))
                        ncolumna++;
                        }
                    }
               
                break;                                                    //correr a la Derecha;
                
                case 3:
                ncolumna--;
                if(ncolumna<1)
                ncolumna=1;
                break;                                                    //correr a la izquierda;
                /*
                case 4:
                cont++;
                if(cont>8)cont=8;
                break; 
                */
                }
    }

void imp_mat(uint8_t *temp){                                 //se genera la variable global cont.
            mat_tmp1[0]=(mat_tmp[0]+ mat_act[cont-3]);
            mat_tmp1[1]=(mat_tmp[1]+ mat_act[cont-2]);
            mat_tmp1[2]=(mat_tmp[2]+ mat_act[cont-1]);
            mat_tmp1[3]=(mat_tmp[3]+ mat_act[cont]);         //condicionador de funcion, se descarta por una funcion smart.                     
            sendSPI(cont-3,mat_tmp1[0]);
            sendSPI(cont-2,mat_tmp1[1]);
            sendSPI(cont-1,mat_tmp1[2]);
            sendSPI(cont  ,mat_tmp1[3]);                     //pasa de i+2 a i+1
            wait_ms(VEL);
}

void dibujar(char type_fig,char grados,char columna)
{    
    switch (type_fig){                                  //Se envia el vector que contiene la figura a la funcion copiar matriz.
        case 1: if(columna>7)
                columna=7;
                cop_mat(5,1,1,FIG_ALL,columna); break;  //1: cuadro;
        
        case 2: if(grados==1 || grados==3)              
                cop_mat(0,0,0,FIG_ALL,columna);
                if(grados==2 || grados==4)
                cop_mat(5,5,2,FIG_ALL,columna);         //2: I;    
                break;
                  
        case 3: if(grados==1)
                cop_mat(0,0,1,FIG_ALL,columna);         //3: L; 
                if(grados==2)
                cop_mat(5,2,0,FIG_ALL,columna);
                if(grados==3)
                cop_mat(1,3,3,FIG_ALL,columna);
                if(grados==4)
                cop_mat(5,6,2,FIG_ALL,columna);
                break;
        
        case 4: if(grados==1)
                cop_mat(5,3,2,FIG_ALL,columna);         //4: T;
                if(grados==2)
                cop_mat(0,1,0,FIG_ALL,columna);
                if(grados==3)
                cop_mat(5,2,3,FIG_ALL,columna);
                if(grados==4)
                cop_mat(3,1,3,FIG_ALL,columna);
                break;
        
        case 5: if(grados==1 || grados==3)
                cop_mat(5,4,1,FIG_ALL,columna);         //5: S; 
                if(grados==2 || grados==4)
                cop_mat(0,1,3,FIG_ALL,columna);
                break; 
    }  
}

void fichas(){
    ficha= rand() % 5+1; 
    //grados= rand() % 4+1;
    ncolumna=4; 
    }
    
void buscar_linea()
{
    for(uint8_t i=0;i<9;i++)
    {
        if(mat_act[i]==255)
        {
            linea_spi++;
            for(uint8_t a=i;a>=1;a--)
            {
                sendSPI(a,mat_act[a-1]);
                mat_act[a]=mat_act[a-1];
            }
        }
    }
    if(linea_spi==2)
    {
        com_tar.putc(1);
        cara_feliz();
    }
}

//--------------------------------------------------
//-------------------TICKER------------------------
//--------------------------------------------------  
void attime() 
{
    void correr_fig();
    //blink();
    boton();
    if (command.readable())
    {
    int x=com_tar.getc();
    if(x==1)
    cara_triste();
    //command.printf("Button pressed %b\n", _boton);
    }
}; 

//--------------------------------------------------
//-------------------BOTON------------------------
//--------------------------------------------------  
void boton()
{
    if (pulsador == 0) 
        {
            //command.printf("Button pressed %b\n", _boton);
            _boton=!_boton;
        }
}  

//--------------------------------------------------
//-------------------VELOCIDAD-----------------------
//-------------------------------------------------- 
int velocidad(float _acc[3])
{
    int vel,x=1,y=2; //
    int acc[3];
        acc[0]=(int)_acc[0];
        acc[1]=(int)_acc[1];
       if((acc[0]>GIRO) || (acc[0]<-GIRO) || (acc[1]>GIRO) || (acc[1]<-GIRO))
        {
                if((acc[0]>(GIRO+x)) || (acc[0]<-(GIRO+x)) || (acc[1]>(GIRO+x)) || (acc[1]<-(GIRO+x)))
                    {
                        vel=300; 
                        if((acc[0]>(GIRO+y)) || (acc[0]<-(GIRO+y)) || (acc[1]>(GIRO+y)) || (acc[1]<-(GIRO+y)))
                            vel=100;
                    }
                else
                    vel=500;   
        }
    return vel;
}

//--------------------------------------------------
//-------------------MAIN------------------------
//--------------------------------------------------   
int main() {
    timer.attach(&attime, 0.3);
    test();
    borrar();
    while(1){
            fichas();
            buscar_fil();
            cont=0;
            
            while (cont<fila){
                        correr_fig();    
                        dibujar(ficha,grados,ncolumna);
                        buscar_fil();
                        imp_mat(mat_tmp);
                        wait_ms(VEL*2);
                        }       
            guardar_mat();
            buscar_linea(); 
        }
    }