#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PC_9;
  PinName const SCL = PB_8;
  //SDA PC_9
  //SCL PB_8

#define MMA8451_I2C_ADDRESS (0x68)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    Serial pc(USBTX, USBRX); // tx, rx
    float threshold = .50;
    float min_threshold = 0.25;
    


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        pc.printf("acelerometro: %d\n", x);
        pc.printf("acelerometro: %d\n", y);
        pc.printf("acelerometro: %d\n", z);
        //flat
        if(z>threshold && abs(x)< min_threshold && abs(y)< min_threshold)
        {
          pc.printf("FLAT\n\r");
          pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
          
        }else
        if(y<-threshold && abs(z)<min_threshold && abs(x)<min_threshold)
        {
            pc.printf("RIGHT\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(y>threshold && abs(z)<min_threshold && abs(x)<min_threshold)
        {
            pc.printf("LEFT\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(x< -threshold && abs(z)<min_threshold && abs(y)<min_threshold)
        {
            pc.printf("DOWN\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(x> threshold && abs(z)<min_threshold && abs(y)<min_threshold)
        {
            pc.printf("UP\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(z<-threshold && abs(y)<min_threshold && abs(x)<min_threshold)
        {
            pc.printf("OVER\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }
        Thread::wait(300);
        
    }
}
