#include "mbed.h"
#include "ReceiverIR.h"
#include "rtos.h"
//#include <stdint.h>

ReceiverIR ir_rx(p16);
Serial pc(USBTX, USBRX);
uint32_t remoter_code;
void remoter_thread(void const *argument){
     RemoteIR::Format format;
    //uint8_t buf[32];
    uint8_t buf[32];
    //uint32_t bitcount;
    int bitcount;
    
     while(1){
        // 受信待ち
        if (ir_rx.getState() == ReceiverIR::Received) {
     //       pc.printf("get ir data\r\n");
            // コード受信
            //bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 16);
            remoter_code=0;
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            pc.printf("bitcount %d\r\n",bitcount);
          
            for(int i=0;i<(bitcount>>3);i++){
                pc.printf("16 : %02X \r\n",buf[i]);
                pc.printf("10 : %d\r\n",buf[i]);
                remoter_code=remoter_code<<(i > 0 ? 8 : 0);
                //remoter_code << 2;
                remoter_code += buf[i];
            }
            pc.printf("remote_code %08X \r\n",remoter_code);
            pc.printf("\r\n");
        }
    }
}
int main() {
    Thread thread_Re(remoter_thread , NULL ,  osPriorityHigh);
    // ポートD6を赤外線受信モジュールの接続先に指定
    while(true){
        Thread::wait(5);
    }
   
}