/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "TextLCD.h"
#define MIN_V 2.0
#define MAX_V 2.67
//0.107 2.23,3.3
I2C i2c_lcd(p28, p27);
TextLCD_I2C lcd(&i2c_lcd, (0x27 << 1), TextLCD::LCD16x2, TextLCD::HD44780);

int b = 0;
AnalogIn battery(p15);
Serial pc(USBTX, USBRX); // USBシリアルポートのインスタンス
int flag_b = 0;
int flag_t = 0;
void lcdBacklight(void const *argument);
RtosTimer bTimer(lcdBacklight, osTimerPeriodic);
void lcdBacklight(void const *argument){
    if(flag_b == 1){
        lcd.setBacklight(TextLCD::LightOn);
    }else{
        lcd.setBacklight(TextLCD::LightOff);
    }
    flag_b = !flag_b;
}
void bChange(){
        lcd.setBacklight(TextLCD::LightOn);
        while(true){
            //double test = battery.read();
            b = (int)(((battery.read() * 3.3 - MIN_V)/0.67)*10+0.5)*10;
            //b = (int)(((test*3.3 - MIN_V))/(MAX_V) + 0.5)*10;
            pc.printf("test*3.3=%f,b = %d\r\n",test*3.3,b);
            if(b < 0){//すべての機能停止
                /*lcd.setBacklight(TextLCD::LightOff);
                bTimer.stop();
                exit(1);*/
                b = 0;
            }else if(b > 100){
                b = 100;
            }
            lcd.locate(0,0);
            lcd.printf("Battery:%3d%%",b);
            if(b <= 30){
                if(flag_t == 0){
                    bTimer.start(500);
                    flag_t = 1;
                }
            }else{
                if(flag_t == 1){
                    bTimer.stop();
                    lcd.setBacklight(TextLCD::LightOn);
                    flag_t = 0;
                }
            }
            wait_us(1000000);
            /*for(double i = MAX_V;i > MIN_V;i -= 0.05){
                b = (int)((i - MIN_V)/0.107 + 0.5)*10;
                //printf("i = %.2f,b=%d%\r\n",i,b);
                lcd.locate(0,0);
                lcd.printf("Battery:%3d%%",b);
                if(b <= 30){
                    for(int j = 0;j*(2*b+20) < 200;j++){
                        lcd.setBacklight(TextLCD::LightOff);
                        thread_sleep_for(b+10);
                        lcd.setBacklight(TextLCD::LightOn);
                        thread_sleep_for(b+10);
                    }
                }else{
                    thread_sleep_for(200);
                }
            }*/
        }
        

}

/*void bChange{
    
}*/

int main()
{
    //Thread thread(change,NULL,osPriorityNormal);
    Thread thread;
    thread.start(bChange);
    while (true) {
        wait(1);
    }
}
