#include "mbed.h"

DigitalOut  trig(p6);    // 超音波センサのtrigピンをp6に接続
DigitalIn   echo(p7);    // 超音波センサのechoピンをp7に接続
PwmOut      servo(p25);    // サーボコントロールピン(p25)
PwmOut      motorR2(p21);   // 右モーター後退
PwmOut      motorR1(p22);   // 右モーター前進
PwmOut      motorL2(p23);   // 左モーター後退
PwmOut      motorL1(p24);   // 左モーター前進

enum Mode{
    ADVANCE = 1,
    RIGHT,
    LEFT,
    BACK,
    STOP,
    LINE_TRACE,
    AVOIDANCE,
    READY
};

Timer timer;            // 距離計測用タイマー

/* 障害物検知用の変数設定 */
int SC;                 // 正面   
int SL;                 // 左
int SR;                 // 右
int SLD;                // 左前
int SRD;                // 右前
int flag_a = 0;           // 障害物有無のフラグ
const int limit = 20;   // 障害物の距離のリミット(単位：cm)
int DT;                 // 距離
int houkou;             // 進行方向(1:前 2:左 3:右)
int far;                // 最も遠い距離
int i;                  // ループ変数
int t1,t2 = 0;
int run;


void motor(){
        /* 走行状態の場合分け */
        switch(run){
            /* 前進 */
            case ADVANCE:
                motorR1 = 0.6;  // 右前進モーターON
                motorR2 = 0;                  // 右後退モーターOFF
                motorL1 = 0.6;  // 左前進モーターON
                motorL2 = 0;                  // 左後退モーターOFF
                break;
            /* 右折 */
            case RIGHT:
                motorR1 = 0;                  // 右前進モーターOFF
                motorR2 = 0.6;  // 右後退モーターON
                motorL1 = 0.6;  // 左前進モーターON
                motorL2 = 0;                  // 左後退モーターOFF
                break;
            /* 左折 */
            case LEFT:
                motorR1 = 0.6;  // 右前進モーターON
                motorR2 = 0;                  // 右後退モーターOFF
                motorL1 = 0;                  // 左前進モーターOFF
                motorL2 = 0.6;  // 左後退モーターON
                break;
            /* 後退 */
            case BACK:
                motorR1 = 0;                  // 右前進モーターOFF
                motorR2 = 0.6;  // 右後退モーターON
                motorL1 = 0;                  // 左前進モーターOFF
                motorL2 = 0.6;  // 左後退モーターON
                break;
            /* 停止 */
            case STOP:
                motorR1 = 0;                  // 右前進モーターOFF
                motorR2 = 0;                  // 右後退モーターOFF
                motorL1 = 0;                  // 左前進モーターOFF
                motorL2 = 0;                  // 左後退モーターOFF
                break;
        }
}

/* 超音波センサ関数 */
int watch(){
        do{
        trig = 0;
        wait_ms(5);       // 5ms待つ
        trig = 1;
        wait_ms(15);      // 15ms待つ
        trig = 0;
        timer.start();
        t1=timer.read_ms();
        t2=timer.read_ms();
        while(echo.read() == 0 &&(t1-t2)<10){
            t1=timer.read_ms();
        }
        timer.stop();
        timer.reset();
        if((t1-t2) >= 10){
        run = STOP;
        motor();
        }
    }while((t1-t2) >= 10);
    timer.start();                  // 距離計測タイマースタート
    while(echo.read() == 1){
    }
    timer.stop();                   // 距離計測タイマーストップ
    DT = (int)(timer.read_us()*0.01657);   // 距離計算
    if(DT > 150){                   // 検知範囲外なら100cmに設定
        DT = 150;
    }
    timer.reset();                  // 距離計測タイマーリセット
    return DT;
}

/* サーボ制御スレッド */
void watchsurrounding(){
    SC = watch();
    if(SC < limit){                 // 正面20cm以内に障害物がある場合
        run = STOP;                 // 停止
        motor();
    }
    servo.pulsewidth_us(1925);      // サーボを左に40度回転
    wait_ms(200);     // 250ms待つ
    SLD = watch();
    if(SLD < limit){                // 左前20cm以内に障害物がある場合
        run = STOP;                 // 停止
        motor();
    }
    servo.pulsewidth_us(2400);      // サーボを左に90度回転
    wait_ms(200);    // 250ms待つ
    SL = watch();
    if(SL < limit){                 // 左20cm以内に障害物がある場合
        run = STOP;                 // 停止
        motor();
    }
    servo.pulsewidth_us(1450);
    wait_ms(90);
    SC = watch();
    if(SC < limit){
        run = STOP;
        motor();
    }
    servo.pulsewidth_us(925);       // サーボを右に40度回転
    wait_ms(200);     // 250ms待つ
    SRD = watch();
    if(SRD < limit){                // 右前20cm以内に障害物がある場合
        run = STOP;                 // 停止
        motor();
    }
    servo.pulsewidth_us(500);       // サーボを右に90度回転
    wait_ms(200);     // 250ms待つ
    SR = watch();
    if(SR < limit){                 // 右20cm以内に障害物がある場合
        run = STOP;                 // 停止
        motor();
    }
    servo.pulsewidth_us(1450);      // サーボを中央位置に戻す
    wait_ms(90);
    if(SC < limit || SLD < limit || SL < limit || SRD < limit || SR < limit){ // 20cm以内に障害物を検知した場合
        flag_a = 1;                   // フラグに1をセット
    }
}

/* 障害物回避走行 */
void avoidance(){
        watchsurrounding();
        if(flag_a == 0){                      // 障害物がない場合
            run = ADVANCE;                  // 前進
            motor();
        }
        else{                               // 障害物がある場合                   
            i = 0;
            if(SC < 15){                    // 正面15cm以内に障害物が現れた場合
                run = BACK;                 // 後退
                motor();
                while(watch() < limit){     // 正面20cm以内に障害物がある間
                }
                run = STOP;                 // 停止
                motor();                 
            }
            if(SC < limit && SLD < limit && SL < limit && SRD < limit && SR < limit){   // 全方向に障害物がある場合
                run = LEFT;                 // 左折
                motor();                   
                while(i < 3){             // 進行方向確認
                    if(watch() > limit){    
                        i++;                
                    }
                    else{                   
                        i = 0;              
                    }
                }
                run = STOP;                 // 停止
                motor();
            }
            else {                          // 全方向以外                          
                far = SC;                   // 正面を最も遠い距離に設定
                houkou = 1;                 // 進行方向を前に設定
                if(far < SLD || far < SL){  // 左または左前がより遠い場合
                    if(SL < SLD){           // 左前が左より遠い場合
                        far = SLD;          // 左前を最も遠い距離に設定
                    }
                    else{                   // 左が左前より遠い場合
                        far = SL;           // 左を最も遠い距離に設定
                    }
                    houkou = 2;             // 進行方向を左に設定
                }
                if(far < SRD || far < SR){  // 右または右前がより遠い場合
                    if(SR < SRD){           // 右前が右より遠い場合
                        far = SRD;          // 右前を最も遠い距離に設定
                    }
                    else{                   // 右が右前よりも遠い場合
                        far = SR;           // 右を最も遠い距離に設定
                    }
                    houkou = 3;             // 進行方向を右に設定
                }
                switch(houkou){                         // 進行方向の場合分け
                    case 1:                             // 前の場合
                        run = ADVANCE;                  // 前進
                        motor();
                        wait_ms(1000);          // 1秒待つ
                        break;
                    case 2:                             // 左の場合
                        run = LEFT;                     // 左折
                        motor();
                        while(i < 3){                 // 進行方向確認
                            if(watch() > (far - 2)){    
                                i++;
                            }
                            else{
                                i = 0;
                            }
                        }
                        run = STOP;                     // 停止
                        motor();
                        break;
                    case 3:                             // 右の場合
                        run = RIGHT;                    // 右折
                        motor();
                        while(i < 3){                 // 進行方向確認
                            if(watch() > (far - 2)){
                                i++;
                            }
                            else{
                                i = 0;
                            }
                        }
                        run = STOP;                     // 停止
                        motor();
                        break;
                }
            }
        }
        flag_a = 0;                   // フラグを0にセット
}    

int main(){
  servo.pulsewidth_us(1450);
  wait_ms(50);
  while(1){
      avoidance();
  }
}      
