#include "mbed.h"

RawSerial pc(USBTX, USBRX);
RawSerial esp(p13, p14); // tx, rx

enum MODE {
    READY = -1,
    ADVANCE = 1,
    RIGHT,
    LEFT,
    BACK,
    STOP,
    LINE_TRACE,     //  6：ライントレース
    AVOIDANCE,      //  7：障害物回避
    SPEED,          //  8：スピード制御
};

// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);

Timer t1;
Timer t2;

struct tm t;

int flag_sp = 0;
int mode = ADVANCE;
int beforeMode = mode;

int bufflen, DataRX, ount, getcount, replycount, servreq, timeout;
int bufl, ipdLen, linkID, weberror, webcounter,click_flag;
float temperature, AdcIn, Ht;
float R1=100000, R2=10000; // resistor values to give a 10:1 reduction of measured AnalogIn voltage
char Vcc[10];
char webcount[8];
char type[16];
char type1[16];
char channel[2];
char cmdbuff[32];
char replybuff[1024];

char webdata[1024]; // This may need to be bigger depending on WEB browser used
char webbuff[4096*4];     // Currently using 1986 characters, Increase this if more web page data added


void SendCMD(),getreply(),ReadWebData(),startserver(),sendpage(),SendWEB(),sendcheck(),touchuan();


int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.

char ssid[32] = "mbed02"; // enter WiFi router ssid inside the quotes
char pwd [32] = "0123456789a"; // enter WiFi router password inside the quotes

// Serial Interrupt read ESP data
void callback()
{
    //pc.printf("\n\r------------ callback is being called --------------\n\r");
    led3=1;
    while (esp.readable()) {
        webbuff[ount] = esp.getc();
        ount++;
    }
    if(strlen(webbuff)>bufflen) {
        pc.printf("\f\n\r------------ webbuff over bufflen --------------\n\r");
        DataRX=1;
        led3=0;
    }
}

int main()
{
    pc.baud(115200);

    pc.printf("\f\n\r------------ ESP8266 Hardware Reset psq --------------\n\r");
    wait(0.5);
    led1=1,led2=0,led3=0;
    timeout=6000;
    getcount=500;
    getreply();
    esp.baud(115200);   // ESP8266 baudrate. Maximum on KLxx' is 115200, 230400 works on K20 and K22F
    startserver();

    while(1) {
        if(DataRX==1) {
            pc.printf("\f\n\r------------ main while > if --------------\n\r");
            click_flag = 1;
            ReadWebData();
            pc.printf("\f\n\r------------ click_flag=%d --------------\n\r",click_flag);
            //if ((servreq == 1 && weberror == 0) && click_flag == 1) {
            if (servreq == 1 && weberror == 0) {
                pc.printf("\f\n\r------------ befor send page --------------\n\r");
                sendpage();
            }
            pc.printf("\f\n\r------------ send_check begin --------------\n\r");

            //sendcheck();
            pc.printf("\f\n\r------------ ssend_check end--------------\n\r");

            esp.attach(&callback);
            pc.printf(" IPD Data:\r\n\n Link ID = %d,\r\n IPD Header Length = %d \r\n IPD Type = %s\r\n", linkID, ipdLen, type);
            pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata);
            pc.printf("  Web Characters sent : %d\n\n", bufl);
            pc.printf("  -------------------------------------\n\n");
            servreq=0;
        }
    }
}
// Static WEB page
void sendpage()
{
// WEB page data

    strcpy(webbuff, "<!DOCTYPE html>");
    strcat(webbuff, "<html><head><title>RobotCar</title><meta name='viewport' content='width=device-width'/>");
    strcat(webbuff, "<style type=\"text/css\">.noselect{ width:100px;height:60px;}.light{ width:100px;height:60px;background-color:#00ff66;}</style>");
    strcat(webbuff, "</head><body><center><p><strong>Robot Car Remote Controller");
    strcat(webbuff, "</strong></p><td style='vertical-align:top;'><strong>Battery level ");
    strcat(webbuff, "<input type=\"text\" id=\"leftms\" size=4 value=250>%</strong>");
    strcat(webbuff, "</td></p>");
    strcat(webbuff, "<br>");
    strcat(webbuff, "<table><tr><td></td><td>");

    switch(mode) {
        case ADVANCE:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"light\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case LEFT:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"light\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case STOP:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"light\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case RIGHT:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"light\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case BACK:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"light\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr><td>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case AVOIDANCE:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"light\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        case LINE_TRACE:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"light\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
        default:
            strcat(webbuff, "<button id='gobtn' type='button' class=\"noselect\"  value=\"GO\"  onClick='send_mes(this.id,this.value)'>GO");
            strcat(webbuff, "</button></td><td></td></tr><tr><td>");
            strcat(webbuff, "<button id='leftbtn' type='button' class=\"noselect\" value=\"LEFT\"  onClick='send_mes(this.id,this.value)' >LEFT");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='stopbtn' type='button' class=\"noselect\" value=\"STOP\"  onClick='send_mes(this.id,this.value)' >STOP");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='rightbtn' type='button' class=\"noselect\" value=\"RIGHT\"  onClick='send_mes(this.id,this.value)' >RIGHT");
            strcat(webbuff, "</button></td></tr><td></td><td>");
            strcat(webbuff, "<button id='backbtn' type='button' class=\"noselect\" value=\"BACK\" onClick='send_mes(this.id,this.value)' >BACK");
            strcat(webbuff, "</button></td><td style='vertical-align:top; text-align:right;'></td></tr></table>");
            strcat(webbuff, "<strong>Mode</strong>");
            strcat(webbuff, "<table><tr><td><button id='avoidbtn' type='button' class=\"noselect\" value=\"AVOIDANCE\"  onClick='send_mes(this.id,this.value)' >");
            strcat(webbuff, "AVOIDANCE</button></td><td>");
            strcat(webbuff, "<button id='tracebtn' type='button' class=\"noselect\" value=\"LINE_TRACE\"  onClick='send_mes(this.id,this.value)' >LINE_TRACE");
            break;
    }
    strcat(webbuff, "</button></td></tr></table>");
    strcat(webbuff, "<strong>Speed</strong>");
    strcat(webbuff, "<table><tr><td>");
    //ready示速度だけ点灯
    switch (flag_sp) {
        case 0:
            strcat(webbuff, "<button id='sp1btn' type='button' class=\"light\" value=\"Normal\"  onClick='send_mes_spe(this.id,this.value)' >Normal");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp2btn' type='button' class=\"noselect\" value=\"Fast\"  onClick='send_mes_spe(this.id,this.value)' >Fast");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp3btn' type='button' class=\"noselect\" value=\"VeryFast\"  onClick='send_mes_spe(this.id,this.value)' >VeryFast");
            break;
        case 1:
            strcat(webbuff, "<button id='sp1btn' type='button' class=\"noselect\" value=\"Normal\"  onClick='send_mes_spe(this.id,this.value)' >Normal");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp2btn' type='button' class=\"light\" value=\"Fast\"  onClick='send_mes_spe(this.id,this.value)' >Fast");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp3btn' type='button' class=\"noselect\" value=\"VeryFast\"  onClick='send_mes_spe(this.id,this.value)' >VeryFast");
            break;
        case 2:
            strcat(webbuff, "<button id='sp1btn' type='button' class=\"noselect\" value=\"Normal\"  onClick='send_mes_spe(this.id,this.value)' >Normal");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp2btn' type='button' class=\"noselect\" value=\"Fast\"  onClick='send_mes_spe(this.id,this.value)' >Fast");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp3btn' type='button' class=\"light\" value=\"VeryFast\"  onClick='send_mes_spe(this.id,this.value)' >VeryFast");
            break;
        default:
            strcat(webbuff, "<button id='sp1btn' type='button' class=\"noselect\" value=\"Normal\"  onClick='send_mes_spe(this.id,this.value)' >Normal");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp2btn' type='button' class=\"noselect\" value=\"Fast\"  onClick='send_mes_spe(this.id,this.value)' >Fast");
            strcat(webbuff, "</button></td><td>");
            strcat(webbuff, "<button id='sp3btn' type='button' class=\"noselect\" value=\"VeryFast\"  onClick='send_mes_spe(this.id,this.value)' >VeryFast");
            break;
    }
    strcat(webbuff, "</button></td></tr></table>");

    strcat(webbuff, "</center>");
    strcat(webbuff, "</body>");
    strcat(webbuff, "</html>");
    strcat(webbuff, "<script language=\"javascript\" type=\"text/javascript\">");
    
    strcat(webbuff, "function htmlacs(url) {");
    strcat(webbuff, "var xhr = new XMLHttpRequest();");
    strcat(webbuff, "xhr.open(\"GET\", url);");
    strcat(webbuff, "xhr.send(\"\");");
    strcat(webbuff, "}");
    
    strcat(webbuff, "function send_mes(btnmes,btnval){");
    strcat(webbuff, "console.log(btnval);");

    strcat(webbuff, "var url = \"http://\" + window.location.hostname + \"/cargo?a=\" + btnval;");
    strcat(webbuff, "htmlacs(url);");
    strcat(webbuff, "console.log(url);");
    strcat(webbuff, "var buttons = document.getElementsByTagName(\"button\");");
    strcat(webbuff, "for(var i=0;i<7;i++){");
    strcat(webbuff, "if(buttons[i].value == btnval){");
    strcat(webbuff, "buttons[i].className=\"light\";");
    strcat(webbuff, "}else{");
    strcat(webbuff, "buttons[i].className=\"noselect\";");
    strcat(webbuff, "}");
    strcat(webbuff, "}");
    strcat(webbuff, "}");
    
    strcat(webbuff, "function send_mes_spe(btnmes,btnval){");
    strcat(webbuff, "var url = \"http://\" + window.location.hostname + \"/cargo?a=\" + btnval;");
    strcat(webbuff, "htmlacs(url);");
    strcat(webbuff, "console.log(url);");
    strcat(webbuff, "var buttons = document.getElementsByTagName(\"button\");");
    strcat(webbuff, "for(var i=7;i<10;i++){");
    strcat(webbuff, "if(buttons[i].value == btnval){");
    strcat(webbuff, "buttons[i].className=\"light\";");
    strcat(webbuff, "}else{");
    strcat(webbuff, "buttons[i].className=\"noselect\";");
    strcat(webbuff, "}");
    strcat(webbuff, "}");
    strcat(webbuff, "}");
    strcat(webbuff, "</script>");
// end of WEB page data
    bufl = strlen(webbuff); // get total page buffer length
    //sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.

    sprintf(cmdbuff,"AT+CIPSENDBUF=%d,%d\r\n", linkID, (bufl>2048?2048:bufl)); // send IPD link channel and buffer character length.
    timeout=500;
    getcount=40;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("\n++++++++++ AT+CIPSENDBUF=%d,%d+++++++++\r\n", linkID, (bufl>2048?2048:bufl));

    pc.printf("\n++++++++++ bufl is %d ++++++++++\r\n",bufl);

    //pastthrough mode
    SendWEB();  // send web page
    pc.printf("\n++++++++++ webbuff clear  ++++++++++\r\n");

    memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();
}

// Large WEB buffer data send
void SendWEB()
{
    int i=0;
    if(esp.writeable()) {
        while(webbuff[i]!='\0') {
            esp.putc(webbuff[i]);

            //****
            //output at command when 2000
            if(((i%2047)==0) && (i>0)) {
                //wait_ms(10);
                sprintf(cmdbuff,"AT+CIPSENDBUF=%d,%d\r\n", linkID, (bufl-2048)>2048?2048:(bufl-2048)); // send IPD link channel and buffer character length.
                pc.printf("\r\n++++++++++ AT+CIPSENDBUF=%d,%d ++++++++++\r\n", linkID, (bufl-2048)>2048?2048:(bufl-2048));
                timeout=600;
                getcount=50;
                SendCMD();
                getreply();
                pc.printf(replybuff);
                pc.printf("\r\n+++++++++++++++++++\r\n");
            }
            //****
            i++;
            pc.printf("%c",webbuff[i]);
        }
    }
    pc.printf("\n++++++++++ send web i= %dinfo ++++++++++\r\n",i);
}



void sendcheck()
{
    weberror=1;
    timeout=500;
    getcount=24;
    t2.reset();
    t2.start();

    /*
    while(weberror==1 && t2.read() <5) {
        getreply();
        if (strstr(replybuff, "SEND OK") != NULL) {
            weberror=0;   // wait for valid SEND OK
        }
    }
    */
    if(weberror==1) { // restart connection
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n");
        timeout=500;
        getcount=10;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
        timeout=500;
        getcount=10;
        SendCMD();
        getreply();
        pc.printf(replybuff);
    } else {
        sprintf(cmdbuff, "AT+CIPCLOSE=%s\r\n",channel); // close current connection
        SendCMD();
        getreply();
        pc.printf(replybuff);
    }
    t2.reset();
}

// Reads and processes GET and POST web data
void ReadWebData()
{
    pc.printf("+++++++++++++++++Read Web Data+++++++++++++++++++++\r\n");
    wait_ms(200);
    esp.attach(NULL);
    ount=0;
    DataRX=0;
    weberror=0;
    memset(webdata, '\0', sizeof(webdata));
    int x = strcspn (webbuff,"+");
    if(x) {
        strcpy(webdata, webbuff + x);
        weberror=0;
        int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);
        //int i=0;
        pc.printf("+++++++++++++++++succed rec begin+++++++++++++++++++++\r\n");
        pc.printf("%s",webdata);
        pc.printf("+++++++++++++++++succed rec end+++++++++++++++++++++\r\n");
        if( strstr(webdata, "GO") != NULL ) {
            pc.printf("+++++++++++++++++前進+++++++++++++++++++++\r\n");
            //run = ADVANCE;           // 前進
            mode = READY;            // モードs変更
//            display();          // ディスプレイ表示

        }

        if( strstr(webdata, "LEFT") != NULL ) {
            pc.printf("+++++++++++++++++左折+++++++++++++++++++++\r\n");
            //run = LEFT;
            mode = READY;
//            display();          // ディスプレイ表示
        }

        if( strstr(webdata, "STOP") != NULL ) {
            pc.printf("+++++++++++++++++停止+++++++++++++++++++++\r\n");
//            run = STOP;
            mode = READY;
//            display();          // ディスプレイ表示
        }

        if( strstr(webdata, "RIGHT") != NULL ) {
            pc.printf("+++++++++++++++++右折+++++++++++++++++++++\r\n");
//            run = RIGHT;
            mode = READY;
//            display();          // ディスプレイ表示
        }

        if( strstr(webdata, "BACK") != NULL ) {
            pc.printf("+++++++++++++++++後進+++++++++++++++++++++\r\n");
//            run = BACK;
            mode = READY;
//            display();          // ディスプレイ表示
        }
        pc.printf("+++++++++++++++++succed+++++++++++++++++++++");

        if( strstr(webdata, "AVOIDANCE") != NULL ) {
            pc.printf("+++++++++++++++++AVOIDANCE+++++++++++++++++++++");
            //if(avoi_thread->get_state() == Thread::Deleted) {
            //    delete avoi_thread;
            //    avoi_thread = new Thread(avoidance);
            //    avoi_thread -> set_priority(osPriorityHigh);
            //}
            mode=AVOIDANCE;
//            run = ADVANCE;
//            display();          // ディスプレイ表示
        }
        if( strstr(webdata, "LINE_TRACE") != NULL ) {
            pc.printf("+++++++++++++++++LINET RACE+++++++++++++++++++++");
            pc.printf("mode = LINE_TRACE\r\n");
            //if(trace_thread->get_state() == Thread::Deleted) {
            //    delete trace_thread;
            //    trace_thread = new Thread(trace);
            //    trace_thread -> set_priority(osPriorityHigh);
            //}
            mode=LINE_TRACE;
//            display();          // ディスプレイ表示
        }
        if( strstr(webdata, "Normal") != NULL ) {
            pc.printf("++++++++++++++++++Normal++++++++++++++++++++");
            mode = SPEED;       // スピードモード
            flag_sp = 0;
//            display();          // ディスプレイ表示
            mode = beforeMode;  // 現在のモードに前回のモードを設定
        }
        if( strstr(webdata, "Fast") != NULL ) {
            pc.printf("++++++++++++++++++++Fast++++++++++++++++++");
            mode = SPEED;       // スピードモード
            flag_sp = 1;
//            display();          // ディスプレイ表示
            mode = beforeMode;  // 現在のモードに前回のモードを設定
        }
        if( strstr(webdata, "VeryFast") != NULL ) {
            pc.printf("+++++++++++++++++++VeryFast+++++++++++++++++++");
            mode = SPEED;       // スピードモード d
            flag_sp = 2;
//            display();          // ディスプレイ表示
            mode = beforeMode;  // 現在のモードに前回のモードを設定
        }
        sprintf(channel, "%d",linkID);
        if (strstr(webdata, "GET") != NULL) {
            servreq=1;
        }
        if (strstr(webdata, "POST") != NULL) {
            servreq=1;
        }
        webcounter++;
        sprintf(webcount, "%d",webcounter);
    } else {
        memset(webbuff, '\0', sizeof(webbuff));
        esp.attach(&callback);
        weberror=1;
    }
}
// Starts and restarts webserver if errors detected.
void startserver()
{
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"AT+RST\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("%d",ount);
    if (strstr(replybuff, "OK") != NULL) {
        pc.printf("\n++++++++++ Starting Server ++++++++++\r\n");
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n");  // set multiple connections.
        timeout=500;
        getcount=20;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
        timeout=500;
        getcount=20;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        wait(1);
        sprintf(cmdbuff,"AT+CIPSTO=%d\r\n",SERVtimeout);
        timeout=500;
        getcount=50;
        SendCMD();
        getreply();
        pc.printf(replybuff);
        wait(5);
        pc.printf("\n Getting Server IP \r\n");
        strcpy(cmdbuff, "AT+CIFSR\r\n");
        timeout=2500;
        getcount=200;
        while(weberror==0) {
            SendCMD();
            getreply();
            if (strstr(replybuff, "0.0.0.0") == NULL) {
                weberror=1;   // wait for valid IP
            }
        }
        pc.printf("\n Enter WEB address (IP) found below in your browser \r\n\n");
        pc.printf("\n The MAC address is also shown below,if it is needed \r\n\n");
        replybuff[strlen(replybuff)-1] = '\0';
        //char* IP = replybuff + 5;
        sprintf(webdata,"%s", replybuff);
        pc.printf(webdata);
        led2=1;
        bufflen=200;
        //bufflen=100;
        ount=0;
        pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
        esp.attach(&callback);
    } else {
        pc.printf("\n++++++++++ ESP8266 error, check power/connections ++++++++++\r\n");
        led1=1;
        led2=1;
        led3=1;
        led4=1;
        while(1) {
            led1=!led1;
            led2=!led2;
            led3=!led3;
            led4=!led4;
            wait(1);
        }
    }
    t2.reset();
    t2.start();
}
// ESP Command data send
void SendCMD()
{
    esp.printf("%s", cmdbuff);
}
// Get Command and ESP status replies
void getreply()
{
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset();
    t1.start();
    replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();
            replycount++;
        }
    }
    t1.stop();
}