/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
//#include "platform/mbed_thread.h"
#include "TextLCD.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    5
I2C i2c_lcd(p28, p27);
TextLCD_I2C lcd(&i2c_lcd, (0x26 << 1), TextLCD::LCD16x2, TextLCD::HD44780);
int main()
{
    i2c_lcd.frequency(500);
    lcd.setBacklight(TextLCD::LightOn);
    while (true) {
        lcd.locate(0,0);
        lcd.printf("HELLO MBED!!!");
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
