#include "mbed.h"
#include "ReceiverIR.h"
#include "rtos.h"
#include "TextLCD.h"
#include <string.h>
//#include <stdint.h>
//3.30
//2.23
ReceiverIR ir_rx(p16);
Serial pc(USBTX, USBRX);
I2C i2c_lcd(p28, p27);
TextLCD_I2C lcd(&i2c_lcd, (0x27 << 1), TextLCD::LCD16x2, TextLCD::HD44780);
enum Mode{
    ADVANCE,
    RIGHT,
    LEFT,
    BACK,
    STOP,
    LINE_TRACE,
    AVOIDANCE,
    READY
};

Timer viewTimer;
Mode mode = READY;
int remind = 100;

uint32_t remoter_code;
void remoter_thread(void const *argument){
     RemoteIR::Format format;
    //uint8_t buf[32];
    uint8_t buf[32];
    //uint32_t bitcount;
    int bitcount;
    
     while(1){
        // 受信待ち
        if (ir_rx.getState() == ReceiverIR::Received) {
     //       pc.printf("get ir data\r\n");
            // コード受信
            //bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 16);
            remoter_code=0;
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            pc.printf("bitcount %d\r\n",bitcount);
          
            for(int i=0;i<(bitcount>>3);i++){
                pc.printf("16 : %02X \r\n",buf[i]);
                pc.printf("10 : %d\r\n",buf[i]);
                remoter_code=remoter_code<<(i > 0 ? 8 : 0);
                //remoter_code << 2;
                remoter_code += buf[i];
            }
            pc.printf("remote_code %08X \r\n",remoter_code);
            pc.printf("\r\n");
        }
    }
}

void defaultView(){
    lcd.setAddress(0,0);
    lcd.printf("Battery:");
    lcd.setAddress(0,1);
    lcd.printf("Mode:");
}

void display(){
    /*lcd.cls();
    //i2c_lcd.frequency(500);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.locate(0,0);
    lcd.printf("Battery:%3d%%",remind);
    lcd.locate(0,1);
    lcd.printf("Mode:Ready");*/
    //char DispMode[16];
    while (true) {
        lcd.locate(0,1);
        switch(mode){
            case ADVANCE:
                //strcpy(DispMode,"Mode:Advance");
                lcd.printf("Mode:Advance    ");
                break;
            case RIGHT:
                //strcpy(DispMode,"Mode:Right");
                lcd.printf("Mode:TurnRight  ");
                break;
            case LEFT:
                //strcpy(DispMode,"Mode:Left");
                lcd.printf("Mode:TurnLeft   ");
                break;
            case BACK:
                //strcpy(DispMode,"Mode:Back");
                lcd.printf("Mode:Back       ");
                break;
            case STOP:
                //strcpy(DispMode,"Mode:Stop");
                lcd.printf("Mode:Stop       ");
                break;
            case LINE_TRACE:
                //strcpy(DispMode,"Mode:LineTrace");
                lcd.printf("Mode:LineTrace  ");
                break;
            case AVOIDANCE:
                //strcpy(DispMode,"Mode:Avoidance");
                lcd.printf("Mode:Avoidance  ");
                break;
            case READY:
                //strcpy(DispMode,"Mode:Ready");
                lcd.printf("Mode:Ready      ");
                break;
            case SPEED:
                switch(flag_sp){
                    case(NORMAL):
                        lcd.printf("Speed:Normal    ");
                        break;
                    case(FAST):
                        lcd.printf("Speed:Fast      ");
                        break;
                    case(VERYFAST):
                        lcd.printf("Speed:VeryFast  ");
                        break;
                }
                viewTimer.reset();
                viewTimer.start();                
        }
        //lcd.printf("%16d",DispMode);
        
    }
}

int main() {
//    Thread thread_Re(remoter_thread , NULL ,  osPriorityHigh);
    // ポートD6を赤外線受信モジュールの接続先に指定
    int i = 100;
    int printC = 0;
    lcd.cls();
    //i2c_lcd.frequency(500);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.locate(0,0);
    lcd.printf("Battery:%3d%%",remind);
    lcd.locate(0,1);
    lcd.printf("Mode:Ready");
    while (true) {
        lcd.locate(0,0);
        lcd.locate(8,0);
        lcd.printf("%3d",i--);
        if(i == -1){
            i = 100;
            lcd.locate(0,1);
            /*switch(mode){
                case ADVANCE:
                    lcd.printf("Mode:ADVENCE");
                    break;
                case 0:
                    lcd.printf("Mode:Line.trace ");
                    break;
            }*/
            //lcd.printf("%-11s",);
            
        }
        thread_sleep_for(10);
    }
   
}