#include "mbed.h"


// Creates static event queue
static EventQueue queue(0);
void handler(int count);
// Creates an event for later bound
auto event1 = make_user_allocated_event(handler, 1);
auto event2 = make_user_allocated_event(handler, 2);
// Creates an event bound to the specified event queue
auto event3 = queue.make_user_allocated_event(handler, 3);
 
void handler(int count) {
    printf("UserAllocatedEvent = %d \n\r", count);
    return;
}
 
void post_events(void) 
{ 
    // Events can be posted multiple times and enqueue gracefully until
    // the dispatch function is called.
    event1.call_on(&queue);
    event2.call_on(&queue);
    event3.call();
}

int main() 
{
    Thread event_thread;

    // The event can be manually configured for special timing requirements
    // specified in milliseconds
    // Starting delay - 100 msec
    // Delay between each event - 200msec
    event1.delay(100);
    event1.period(200);
    event2.delay(100);
    event2.period(200);
    event3.delay(100);
    event3.period(200);

    event_thread.start(callback(post_events));

    // Posted events are dispatched in the context of the queue's
    // dispatch function 
    queue.dispatch(400);        // Dispatch time - 400msec
    // 400 msec - Only 2 set of events will be dispatched as period is 200 msec

    event_thread.join();
}
