#include "mbed.h"
#include "SDBlockDevice.h"
#include "MBRBlockDevice.h"
#include "FATFileSystem.h"
    
// Pin mappings for K64F
PinName s0 = PTE3;  // MOSI
PinName s1 = PTE1;  // MISO
PinName s2 = PTE2;  // SCLK
PinName s3 = PTE4;  // CS
    
int main(void) {
    // Create an SD card
    SDBlockDevice sd(s0, s1, s2, s3);
    
    // Create a partition with 1 GB of space
    MBRBlockDevice::partition(&sd, 1, 0x83, 0, 1024*1024);
    
    // Create the block device that represents the partition
    MBRBlockDevice part1(&sd, 1);
    
    // Format the partition with a FAT filesystem
    FATFileSystem::format(&part1);
    
    // Create the FAT filesystem instance, files can now be written to
    // the FAT filesystem in partition 1
    FATFileSystem fat("fat", &part1);
}