/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "BlockDevice.h"
#include "FileSystem.h"
#include "FileSystemStore.h"

using namespace mbed;

#define EXAMPLE_VALUE_BUF_SIZE 64
#define EXAMPLE_KEY_SIZE 16

int main()
{
    printf("\n--- Mbed OS FileSystemStore example ---\n");

    BlockDevice *bd = BlockDevice::get_default_instance();
    FileSystem *fs = FileSystem::get_default_instance();

    char kv_value1[EXAMPLE_VALUE_BUF_SIZE] = {"value1value1value1value1value1value1"};
    char kv_key1[16] = {"key1"};
    char kv_value2[EXAMPLE_VALUE_BUF_SIZE] = {"value2value2value2value2value2value2"};
    char kv_key2[16] = {"key2"};
    char kv_buf[EXAMPLE_VALUE_BUF_SIZE] = {0};
    int err = 0;
    size_t actual_size = 0;

    err = bd->init();
    printf("bd.init -> %d\n", err);

    err = fs->mount(bd);
    if (err) {
        err = fs->reformat(bd);
    }

    FileSystemStore *fsst = new FileSystemStore(fs);

    err = fsst->init();
    printf("fsst.init -> %d\n", err);

    err = fsst->reset();
    printf("fsst.reset -> %d\n", err);

    /* Set (key1,val1) */
    err = fsst->set(kv_key1, kv_value1, strlen(kv_value1), 0);
    printf("fsst.set %s -> %d\n", kv_key1, err);

    /* Set (key2,val2) */
    err = fsst->set(kv_key2, kv_value2, strlen(kv_value2), 0);
    printf("fsst.set %s -> %d\n", kv_key2, err);

    /* Get key1 */
    memset(kv_buf, 0, EXAMPLE_VALUE_BUF_SIZE);
    err = fsst->get(kv_key1, kv_buf, EXAMPLE_VALUE_BUF_SIZE, &actual_size, 0);
    printf("fsst.get %s -> %s\n", kv_key1, kv_buf);

    /* Get key2 */
    memset(kv_buf, 0, EXAMPLE_VALUE_BUF_SIZE);
    err = fsst->get(kv_key2, kv_buf, EXAMPLE_VALUE_BUF_SIZE, &actual_size, 0);
    printf("fsst.get %s -> %s\n", kv_key2, kv_buf);

    err = fsst->reset();
    printf("fsst.reset -> %d\n", err);

    err = fsst->deinit();
    printf("fsst.deinit -> %d\n", err);

    err = bd->deinit();
    printf("bd.deinit -> %d\n", err);

    return 0;
}

