/*
* @file httpd_task.h
*
* @brief HTTPD service task
*
*/

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "HTTPD.h"
#include "httpd_service.h"

HTTPD *httpd;

//LocalFileSystem local("local");
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

void callback_cgi (int id)
{
    int i, n;
    char buf[256];

    strcpy(buf, httpd->getFilename(id));
    strcat(buf, "\r\n");
    strcat(buf, httpd->getQueryString(id));
    strcat(buf, "\r\n");
    n = strlen(buf);

    i = httpd->receive(id, &buf[n], sizeof(buf) - n);
    if (i < 0) return;
    i += n;
    buf[i] = 0;

    printf("CGI %d %s\r\n", id, buf);
    httpd->send(id, buf, i, "Content-Type: text/plain\r\n");
}

void callback_ws (int id)
{
    int i;
    char buf[256];

    i = httpd->receive(id, buf, sizeof(buf)-1);
    if (i < 0) return;
    buf[i] = 0;

    //printf("WS %d %s\r\n", id, buf);
    printf("WS%d %d\r\n", id, i);
    httpd->sendWebsocket(id, buf, i);
}

void callback_rpc (int id)
{
    char buf[40], outbuf[40];

    strcpy(buf, "/");
    httpd->urldecode(httpd->getFilename(id), &buf[1], sizeof(buf) - 2);
    RPC::call(buf, outbuf);

    printf("RPC id %d '%s' '%s'\r\n", id, buf, outbuf);
    httpd->send(id, outbuf, strlen(outbuf), "Content-Type: text/plain\r\n");
}

void httpd_start(int port)
{
//    RPC::add_rpc_class<RpcAnalogIn>();
//    RPC::add_rpc_class<RpcAnalogOut>();
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcPwmOut>();

    httpd = new HTTPD;
    httpd->attach("/cgi-bin/", &callback_cgi);
    httpd->attach("/ws/", &callback_ws);
    httpd->attach("/rpc/", &callback_rpc);
    httpd->attach("/", "/local/");
    httpd->start(port);
    printf("httpd ready\r\n");
}


