/**
 * @file main.h
 *
 * @brief message and interface for main task.
 *
 */
#pragma once

#include <stdint.h>
#include "MainConfig.h"

/**
 * Command Message ID of main task.
 */
typedef enum {
    MSG_IFUP,		/// Start Ethernet
    MSG_IFDOWN, 	/// Stop Ethernet
    MSG_IFSTAT, 	/// Print Ethernet status
} MainMessageId;

typedef struct {
    MainMessageId	msg_id;
    uint32_t		msg_p1;
    uint32_t		msg_p2;
} MainMessage_t;


/**
 * Global configuration instance.
 */
extern MainConfig _config;

/**
 * Send message to main task.
 */
bool send_main_message(MainMessageId msg_id, uint32_t msg_p1, uint32_t msg_p2);


