/*
Demo application for the dconfig library for handling app configuration setting.
*/
#include <stdio.h>
#include "dconfig.h"

class MyConfig : public DConfig
{
public:
	virtual void reset_default(void)
	{
		(*this)["tz"] = "9";
		(*this)["name"] = "my_app";
	}
};

static bool save_to_str(void *user_data, char c)
{
	std::string *buf = (std::string*)user_data;

	buf->push_back(c);
	return true;
}

int main(int argc, char* argv[])
{
	MyConfig mycfg;
	std::string serialized_data;

	// setup initial key & value
	mycfg.reset_default();

	printf("name=%s\r\n", mycfg.lookup_as_cstr("name", ""));
	printf("tz=%d\r\n", mycfg.lookup_as_int("tz", 0));

	// save data to serialized_data and clear mycfg
	mycfg.save_to(save_to_str, &serialized_data);
	mycfg.clear();

	// make sure data is clean
	printf("name=%s\r\n", mycfg.lookup_as_cstr("name", ""));
	printf("tz=%d\r\n", mycfg.lookup_as_int("tz", 0));

	// restore and see its contents
	mycfg.load_from(serialized_data.c_str(), serialized_data.size());
	printf("name=%s\r\n", mycfg.lookup_as_cstr("name", ""));
	printf("tz=%d\r\n", mycfg.lookup_as_int("tz", 0));

	return 0;
}


