#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"

/** Interface to control a standard DC motor 
 *
 * with an H-bridge using a PwmOut and 2 DigitalOuts
 */
class MOTOR {
public:
    MOTOR(PinName PWM, PinName fwd, PinName rev,float period,int select);
    /** Set the mode of the Motor driver
     *
     *select>0 = LAP
     *select=0 = SM(default)
     */
    void setmode(int select);
        
    /** Set the speed of the motor
     * 
     * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
     */
    void speed(float speed);
private:
    int mode;
    PwmOut pwm;
    DigitalOut cw;
    DigitalOut ccw;  
};

#endif