#include "Motor.h"

#include "mbed.h"

MOTOR::MOTOR(PinName PWM, PinName fwd, PinName rev ,float period ,int select):
    pwm(PWM), cw(fwd), ccw(rev)
{
    pwm.period(period);
    if(select>1) {
        mode = 1;
        pwm = 0.5;
    } else {
        mode = 0;
        pwm = 0;
        cw = 0;
        ccw = 0;
    }

}
void MOTOR::speed(float speed)
{
    if(mode == 0) {
        cw  = (speed > 0.0);
        ccw = (speed < 0.0);
        pwm = abs(speed);
    } else if(mode > 0) {
        pwm = 0.5+(speed*0.5);
    }
}

