#include "LIS3DH.h"

LIS3DH::LIS3DH( PinName sda, PinName scl ) : i2c(sda, scl )
{
}


int LIS3DH::start(void)
{
    addr = WRITE_ADDR;
    dbf[0] = LIS3DH_WHO_AM_I;
    i2c.write(addr, dbf,1);
    i2c.read(addr | 1, dbf, 1);
        if  (dbf[0] == I_AM_LIS3DH) {
            return 1;
        }
        else {
            return 0;
        }
}

void LIS3DH::read_data(float a[])
{
    char data[6];
            dbf[0] = LIS3DH_CTRL_REG1;
            dbf[1] = 0x7f;
            i2c.write(addr , dbf , 2);         
            dbf[0] = LIS3DH_OUT_X_L | 0x80;
            i2c.write(addr, dbf, 1);
            i2c.read(addr | 1, data, 6);
            a[0] = float(short((data[1]<<8) | data[0])) *LIS3DH_SENSITIVITY_2G  / 15;
            a[1] = float(short((data[3]<<8) | data[2])) *LIS3DH_SENSITIVITY_2G  / 15;
            a[2] = float(short((data[5]<<8) | data[4])) *LIS3DH_SENSITIVITY_2G  / 15;
     } 