#include "mbed.h"

Serial pc(USBTX,USBRX);
Serial mc(p13,p14);
BusOut select(p5,p6,p7,p8);
PwmOut myled[] = {LED1,LED2,LED3,LED4};
Timer first;
Timer second;
Timeout next;

void test(){
    double signal2,time2;
    uint8_t data2;
    int style2 = 0;
    
    if(mc.readable() == 1){
        data2 = mc.getc();
        second.reset();
        second.start();
            if(data2 > 0 && data2 < 64) {
                signal2 = data2/50.00;
                style2 = 1;
                myled[0] = signal2;
                myled[1] = 0;
                select = style2;
            }else if(data2 > 64 && data2 < 128) {
                signal2 = (data2-64)/50.00;
                style2 = 2;
                myled[1] = signal2;
                myled[0] = 0;
                select = style2;
            }else if(data2 > 128 && data2 < 196) {
                signal2 = (data2-128)/50.00;
                style2 = 4;
                myled[2] = signal2;
                myled[3] = 0;
                select = style2;
            }else if(data2 > 196 && data2 < 256) {
                signal2 = (data2-196)/50.00;
                style2 = 8;
                myled[3] = signal2;
                myled[2] = 0;
                select = style2;
            }else{
                myled[0] = 0;
                myled[1] = 0;
                myled[2] = 0;
                myled[3] = 0;
            }
            second.stop();
            time2 = second.read_us();
            pc.printf("%u_%f__%u_%f\n",data2,signal2,style2,time2);
        }
}
int main() {
    double signal,time;
    uint8_t data;
    int style = 0;
    
    while(1) {
        if(mc.readable() == 1) {
            data = mc.getc();
            first.reset();
            first.start();
            if(data > 0 && data<64) {
                signal = data/50.00;
                style = 1;
                myled[0] = signal;
                myled[1] = 0;
                select = style;
            }else if(data > 64 && data < 128) {
                signal = (data-64)/50.00;
                style = 2;
                myled[1] = signal;
                myled[0] = 0;
                select = style;
            }else if(data > 128 && data < 196) {
                signal = (data-128)/50.00;
                style = 4;
                myled[2] = signal;
                myled[3] = 0;
                select = style;
            }else if(data >196 && data < 256) {
                signal = (data-196)/50.00;
                style = 8;
                myled[3] = signal;
                myled[2] = 0;
                select = style;
            }else{
                myled[0] = 0;
                myled[1] = 0;
                myled[2] = 0;
                myled[3] = 0;
            }
            first.stop();
            time = first.read_us();
            pc.printf("%u_%f_%u_%f\n",data,signal,style,time);
            next.attach_us(test,time);
        }
    }
}            