#include "rt_define.h"

//********************************/
//ܣIICЭʱʱ
//void
//ֵ
//********************************/

void IIC_delay( void )
{
	u8 i = 5;
    while( i )
    {
		i--;
    }	
}

//**********************************/
//ܣIICIOڵĳʼ
//void
//ֵ
//**********************************/

void IIC_Init( void )
{					     
	GPIO_InitTypeDef GPIO_InitStructure;
 
	RCC_APB2PeriphClockCmd(	RCC_APB2Periph_GPIOB, ENABLE );	
    RCC_APB2PeriphClockCmd(	RCC_APB2Periph_GPIOC, ENABLE );	
						 	   
	GPIO_InitStructure.GPIO_Pin   = IIC_SCL_PIN;
	GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_Out_PP ;   //
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init( IIC_SCL_PORT, &GPIO_InitStructure );
	
	GPIO_InitStructure.GPIO_Pin   = IIC_SDA_PIN;
	GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_Out_PP ;   //
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init( IIC_SDA_PORT, &GPIO_InitStructure );

	Set_IIC_SCL;
	Set_IIC_SDA;
}

//***************************/
//ܣIICʼź
//void
//ֵ
//***************************/

void IIC_Start( void )
{
	SDA_OUT();      //sda
	Set_IIC_SDA;	  	  
	Set_IIC_SCL;
	IIC_delay();
 	Clr_IIC_SDA;    //START:when CLK is high,DATA change form high to low 
	IIC_delay();
	Clr_IIC_SCL;    //ǯסI2Cߣ׼ͻ 
}

//***************************/
//ܣIICֹͣź
//void
//ֵ
//***************************/

void IIC_Stop( void )
{
	SDA_OUT();      //sda
	Clr_IIC_SCL;
	Clr_IIC_SDA;    //STOP:when CLK is high DATA change form low to high
 	IIC_delay();
	Set_IIC_SCL; 
	Set_IIC_SDA;    //I2C߽ź
	IIC_delay();							   	
}

//***************************/
//ܣȴӦźŵ
//void
//ֵ1-Ӧʧ
//            0-Ӧɹ
//***************************/

u8 IIC_Wait_Ack( void )
{
	u8 ucErrTime = 0;
	SDA_IN();               //SDAΪ
	
	Set_IIC_SDA;
	IIC_delay();
	
	Set_IIC_SCL;
	IIC_delay();	 
	while( READ_SDA )
	{
		ucErrTime++;
		if( ucErrTime > 250 )
		{
			IIC_Stop();
			return 1;
		}
	}
	Clr_IIC_SCL;           //ʱ0 	   
	return 0;  
} 

//***************************/
//ܣACKӦ
//void
//ֵ
//***************************/

void IIC_Ack( void )
{
	Clr_IIC_SCL;
	SDA_OUT();
	Clr_IIC_SDA;
	IIC_delay();
	Set_IIC_SCL;
	IIC_delay();
	Clr_IIC_SCL;
}

//***************************/
//ܣACKӦ
//void
//ֵ
//***************************/

void IIC_NAck( void )
{
	Clr_IIC_SCL;
	SDA_OUT();
	Set_IIC_SDA;
	IIC_delay();
	Set_IIC_SCL;
	IIC_delay();
	Clr_IIC_SCL;
}					 				     

//*********************************/
//ܣIICһֽڵ
//txd-Ҫ͵
//ֵ
//*********************************/

void IIC_Send_Byte( u8 txd )
{                        
    u8 t;   
	SDA_OUT(); 	    
    Clr_IIC_SCL;         //ʱӿʼݴ
    for( t = 0; t < 8; t++ )
    {              
		if ( ( txd & 0x80 ) >> 7 ) 
		{
			Set_IIC_SDA;
		}
		else 
		{
			Clr_IIC_SDA;
		}
        txd <<= 1; 	  
		IIC_delay();     //TEA5767ʱǱ
		Set_IIC_SCL;
		IIC_delay(); 
		Clr_IIC_SCL;	
		IIC_delay();
    }	 
} 	    
//1ֽڣack=1ʱACKack=0nACK

//*********************************/
//ܣIICȡһֽڵ
//ack-
//ֵȡ
//*********************************/

u8 IIC_Read_Byte( unsigned char ack )
{
	unsigned char i,receive = 0;
	SDA_IN();           //SDAΪ
    for( i = 0; i < 8; i++ )
	{
        Clr_IIC_SCL; 
        IIC_delay();
		Set_IIC_SCL;
        receive <<= 1;
        if( READ_SDA )
		{
			receive++; 
		}			
		IIC_delay(); 
    }					 
    if (!ack)
	{
        IIC_NAck();     //nACK
	}
    else
	{
        IIC_Ack();      //ACK 
	}		
    return receive;
}



