#ifndef RT_IIC_DEFINE_H
#define RT_IIC_DEFINE_H

//#include "stm32f10x.h"

#include "mbed.h"

/*****************IICIOڲ궨***********************/

#define IIC_SCL_PORT              GPIOC
#define IIC_SCL_CLK               RCC_APB2Periph_GPIOC  
#define IIC_SCL_PIN               GPIO_Pin_9

#define IIC_SDA_PORT              GPIOB
#define IIC_SDA_CLK               RCC_APB2Periph_GPIOC  
#define IIC_SDA_PIN               GPIO_Pin_1



#define SDA_IN()  { GPIOB -> CRH &= 0XFFFF0FFF;GPIOB -> CRH |= 8<<12; }
#define SDA_OUT() { GPIOB -> CRH &= 0XFFFF0FFF;GPIOB -> CRH |= 3<<12; }	 

#define Set_IIC_SCL  { GPIO_SetBits( IIC_SCL_PORT,IIC_SCL_PIN ); }
#define Clr_IIC_SCL  { GPIO_ResetBits( IIC_SCL_PORT,IIC_SCL_PIN ); } 

#define Set_IIC_SDA  { GPIO_SetBits( IIC_SDA_PORT,IIC_SDA_PIN); }
#define Clr_IIC_SDA  { GPIO_ResetBits( IIC_SDA_PORT,IIC_SDA_PIN); } 

#define READ_SDA     ( GPIO_ReadInputDataBit( IIC_SDA_PORT, IIC_SDA_PIN ))

/*****************OLEDĵַĺ궨************************/

#define OLED_ADDRESS  0x78

	 
/*****************IICغⲿ*************************/

void IIC_Init( void );                  //ʼIICIO				 
void IIC_Start( void );				    //IICʼź
void IIC_Stop( void );	  			    //IICֹͣź
void IIC_Send_Byte( u8 txd );			//IICһֽ
u8 IIC_Read_Byte( unsigned char ack );  //IICȡһֽ
u8 IIC_Wait_Ack( void ); 				//IICȴACKź
void IIC_Ack( void );					//IICACKź
void IIC_NAck( void );				    //IICACKź

#endif


