import serial.tools.list_ports as lp
import win32api
import sys
import pprint
import subprocess
from os import remove, path
from shutil import copy
from serial import Serial
from time import sleep


putty_path = "C:/Program Files/putty/putty.exe"
putty_start = True

baud = 9600
reset_timeout = 5
tries = 50

def reset_port(comport):
    print('Sending break on %s' % comport)
    i=0
    while 1:
        i+=1
        try:
            portconn = Serial(comport, timeout=1)
            result = True
        except Exception as e:
            result = False
        if result or i>tries:
            break
        else:
            sleep(float(reset_timeout) / float(tries))

    if result:
        portconn.setBaudrate(baud)
        try:
            portconn.sendBreak()
        except:
            try:
                portconn.setBreak(False)
            except:
                result = False

        portconn.close()
    else:
        print('Failed to reset')

def copy_and_open(file, drives, coms, st_board = False):
    if not file:
        return
        
    for drive in drives:
        _, ext = path.splitext(file)
        ext = ext.lower()
        dfile = drive + "/firmware" + ext
        
        if path.isfile(dfile):
            print('Remove old binary %s' % dfile)
            remove(dfile)
        
        print('Copy binary to %s' % drive)
        if st_board:
            subprocess.call(["C:/Program Files/git/bin/cp.exe", file, dfile])
        else:
            copy(file, dfile)
        comport = coms[drives.index(drive)]
        #reset_port(comport)

    sleep(1)
    
    if putty_start and putty_path:
        for comport in coms:
            reset_port(comport)
            print('Open putty on %s' % comport)
            subprocess.Popen([putty_path, "-serial", comport, "-sercfg", str(baud)])

file = sys.argv[1]

mbed_com_ports = []
for p in lp.comports():
    name, data, more = p
    if data.lower().find("mbed serial port") != -1:
        mbed_com_ports.append(name)

mbed_drives = []
for d in xrange(ord('A'), ord('U')):
    try:
        info = win32api.GetVolumeInformation(chr(d) + ":\\")
    except:
        continue
    if info[0].lower().find("mbed") != -1:
        mbed_drives.append(chr(d) + ":")

# ST...
mbed_com_ports_st = []
for p in lp.comports():
    name, data, more = p
    if data.lower().find("stlink") != -1:
        mbed_com_ports_st.append(name)

mbed_drives_st = []
for d in xrange(ord('A'), ord('U')):
    try:
        info = win32api.GetVolumeInformation(chr(d) + ":\\")
    except:
        continue
    if info[0].lower().find("nucleo") != -1:
        mbed_drives_st.append(chr(d) + ":")

# FRDM...
mbed_com_ports_frdm = []
for p in lp.comports():
    name, data, more = p
    if data.lower().find("opensda") != -1:
        mbed_com_ports_frdm.append(name)

mbed_drives_frdm = []
for d in xrange(ord('A'), ord('U')):
    try:
        info = win32api.GetVolumeInformation(chr(d) + ":\\")
    except:
        continue
    if info[0].lower().find("frdm") != -1:
        mbed_drives_frdm.append(chr(d) + ":")


if mbed_drives:
    print "Detected Drives:", ", ".join(mbed_drives)
    if mbed_com_ports:
        print "Detected Ports:", ", ".join(mbed_com_ports)
    copy_and_open(file, mbed_drives, mbed_com_ports)

if mbed_drives_st:
    print "Detected ST Drives:", ", ".join(mbed_drives_st)
    if mbed_com_ports_st:
        print "Detected ST Ports:", ", ".join(mbed_com_ports_st)
    copy_and_open(file, mbed_drives_st, mbed_com_ports_st, 1)

if mbed_drives_frdm:
    print "Detected FRDM Drives:", ", ".join(mbed_drives_frdm)
    if mbed_com_ports_frdm:
        print "Detected FRDM Ports:", ", ".join(mbed_com_ports_frdm)
    copy_and_open(file, mbed_drives_frdm, mbed_com_ports_frdm, 1)

