#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

Ticker flash;
DigitalOut led(LED1);
void flashLED(void){led = !led;}
 
 
int main() 
{
    flash.attach(&flashLED, 1.0f);
    
    EthernetInterface ethernet;
    ethernet.init();    // connect with DHCP
    int ret_val = ethernet.connect();

    if (0 == ret_val) {
        printf("IP Address: %s\n", ethernet.getIPAddress());
    } else {
        error("ethernet failed to connect: %d.\n", ret_val);
    }

    // view @ http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    ws.connect();
    char str[100];
    
    for(int i=0; i<0x7fffffff; ++i) {
        // string with a message
        sprintf(str, "%d WebSocket Hello World over Ethernet", i);
        ws.send(str);
    
        // clear the buffer and wait a sec...
        memset(str, 0, 100);
        wait(0.5f);
    
        // websocket server should echo whatever we sent it
        if (ws.read(str)) {
            printf("rcv'd: %s\n", str);
        }
    }
    ws.close();
    ethernet.disconnect();
    
    while(true);
}