/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

//fix the comment

#include "mbed.h"

DigitalOut LED[] = {(LED1), (LED2), (LED3), (LED4), (LED5), (LED6), (LED7)};// declare 7 LEDs

float delayTime = .05;
float delayMe = .01;

int main() {

    while(1) {
        delayTime = 0.05;
        for(int x = 0; x < 7; x++) {
            LED[x] = 1; // turn on
            wait(delayMe); // delay
        
            LED[x] = 0; // turn off
            wait(delayTime); // delay
        }
        for(int x = 6; x >= 0; x--) {
            LED[x] = 1; // turn on
            wait(delayMe); // delay
        
            LED[x] = 0; // turn off
            wait(delayTime); // delay
        }

        for(int x = 0; x < 7; x++) {
            LED[x] = 1; // turn on
            wait(delayTime); // delay
        }
        for(int x = 6; x >= 0; x--) {
            LED[x] = 0; // turn off
            wait(delayTime); // delay
        }
        

    }
}
