#include "mbed.h"
#include "math.h"
#include "LCD_DISCO_L476VG.h"

#define PI 3.14159265358979323846
#define cadence 0.01
#define PER_max 10
#define A_max 100

LCD_DISCO_L476VG lcd;

Serial pc(SERIAL_TX, SERIAL_RX);
Ticker tick_cadence;
Ticker tick_moy;

InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

bool flag_data = 0, flag_moy = 0;
float A =2, PER = 1;

void interrupt_data(void){
    flag_data = 1;
}
void interrupt_moy(void){
    flag_moy = 1;
}

void ISR_left(void){
    if(PER>0.1) PER-=0.1;
}
void ISR_right(void){
    if(PER<PER_max-0.1) PER += 0.1;
}
void ISR_up(void){
    if(A<A_max-0.1) A += 1;
}
void ISR_down(void){
    if(A>0.1) A -= 0.1;
}

int main(void){
    pc.baud(115200);
    unsigned char display[7] = {0};
    float t, y1, y2, moy;
    
    tick_cadence.attach(&interrupt_data, 0.01);
    tick_moy.attach(&interrupt_moy, 1);
    
    left.rise(&ISR_left);
    right.rise(&ISR_right);
    up.rise(&ISR_up);
    down.rise(&ISR_down);
    
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
//-------------------------------------------------------------------------
    while(1){
        
        if(flag_data){//                       envoi des données
            pc.printf("$%f %f %f;",A, y1, y2);
            flag_data=0;
        }
        if(flag_moy){//                         moyennage
            moy = moy/256;
            pc.printf("$%f %f %f %f;",A, y1, y2, moy);
            
            lcd.Clear();
            sprintf((char*)display,"%f", moy);
            lcd.DisplayString(display);
            
            moy = 0;
            flag_moy = 0;
        }
        else
            moy += y2;
            
    y1 = A*sin(2.0*PI*(1.0/PER)*(t*cadence));
    y2= 2* fabs(y1) ;
    t++;;
    wait(cadence);
    }
}