#include "mbed.h"
 
Ticker flipper;
Serial pc(USBTX, USBRX);

DigitalOut dOut_0(P0_17);   //right arm
//DigitalOut dOut_1(P0_20);   //left arm
//DigitalOut dOut_2(P0_16);   //right leg
//DigitalOut dOut_3(P0_2);    //left leg
DigitalOut dOut_led(P0_0);    //left leg
 
//motion
int data[4][8];    //angle data for servos
int tmp[2];
//softwareUART
unsigned char bitCount,byteCount;   //used in softwareUART
 
void flip() {  //servo drive
    int sum;
    unsigned char out[4];
     
    //calclulate data at start of sending  (every 80*0.417msec)
    if(bitCount == 0 && byteCount == 0){
        for(int i=0; i<1; i++){
            data[i][0] = 0xFF;    //header
            data[i][1] = 0x05;    //number of data
            data[i][2] = tmp[0];     //servo1
            data[i][3] = tmp[0];     //servo2
            data[i][4] = tmp[0];     //servo3
            data[i][5] = 128;     //servo4
            data[i][6] = 128;     //servo5
            //calc checksum
            data[i][7] = data[i][1] + data[i][2] + data[i][3] + data[i][4] + data[i][5] + data[i][6];
            sum = data[i][7];
            sum >>= 8;
            data[i][7] += sum;
        }
    }
 
    //send one bit data (software UART)
    if(bitCount == 0){
        out[0] = out[1] = out[2] = out[3] = 0;         //start bit
    }else if(bitCount == 9){
        out[0] = out[1] = out[2] = out[3] = 1;         //stop bit
    }else{
        out[0] = (data[0][byteCount] & (1 << (bitCount-1))) >> (bitCount-1);
        out[1] = (data[1][byteCount] & (1 << (bitCount-1))) >> (bitCount-1);
        out[2] = (data[2][byteCount] & (1 << (bitCount-1))) >> (bitCount-1);
        out[3] = (data[3][byteCount] & (1 << (bitCount-1))) >> (bitCount-1);
    }
    dOut_0 = out[0];
    //dOut_1 = out[1];
//    dOut_2 = out[2];
//    dOut_3 = out[3];
//     
    bitCount++;
    if(bitCount > 9){
        bitCount = 0;
        byteCount++;
        if(byteCount > 7)byteCount = 0;
    }
}
 

void setup(){
    pc.baud(115200);
    bitCount = byteCount = 0;
    LPC_USART0->CFG |= 1; //Enable USART0
}

void pc_rx() {
    pc.printf("%d\n",tmp[0]);
    
}

int main() {
    setup();
    
    //pc.attach(pc_rx, Serial::RxIrq);
    
    wait(2.0);
    
    flipper.attach_us(&flip, 417);
    
    while(1) {
        int cnt=0;
        while( pc.readable()) 
        { 
            tmp[0] = pc.getc();
            dOut_led = !dOut_led;    
        }
    }
}