#include "mbed.h"
#include "MTSLog.h"

DigitalInOut myPort(PA_0);
//DigitalOut myPort(PA_0);
//DigitalIn myPort(PA_0);
Serial debug(USBTX, USBRX);

main()
{
    int i;
    bool mode = true;
    debug.baud(115200);
    myPort.mode(PullDown);
    mts::MTSLog::setLogLevel(mts::MTSLog::INFO_LEVEL);
    logInfo("Starting PA0 Tester");
    for(i=0; i<200; i++)
    {
        logInfo("Running Loop %d", i);   
        myPort.output();
        int myData = mode ? 0 : 1;
        myPort.write(myData);
        logInfo("Set PA0: %d", myData);
        mode = !mode;
        wait(5);
        myPort.input();
        int value = myPort.read();
        logInfo("PA0 value: %d", value);
        wait(5);
    }
}
    