
#include "mbed.h"
#include "LTC2944.h"
#include "C12832.h"


Serial pc(USBTX, USBRX);  // I/O terminal PC

LTC2944 j(PB_9,PB_8);
C12832 lcd(D11, D13, D12, D7, D10);

DigitalIn Alert(PC_8);
//InterruptIn Alert(PC_8);
//DigitalOut L1(LED1);
Ticker lecture;
char alertflag=0;
char jflag=0;

void lect_j(void)
{
    jflag=1;
}
void razAlert()
{
    alertflag=1;

}
int main()
{
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("mbed ");
//   L1=0;
    //   Alert.fall(&razAlert);
    lecture.attach(&lect_j,2);
    pc.printf("Hello\n");
    j.setRsense(15.0);
    j.setMode(3);  //automatic
    j.setPrescaler(7);  // 4096
    j.setImin(-0.1);
    j.setImax(0.1);

    while(1) {

        //  L1=!Alert;
        if(jflag) {
            float voltage=j.getVoltage();
            float current=j.getCurrent();
            unsigned short charge=j.getAccumulatedCharge();
            pc.printf("voltage %7.3f \n",voltage);
            pc.printf("curent %7.3f \n",current);
            pc.printf("charge %x \n",charge);

            lcd.locate(0,3);
            lcd.printf("V : %7.3f",voltage);
            lcd.locate(0,11);
            lcd.printf("I : %7.3f",current);
            lcd.locate(0,20);
            lcd.printf("C : %5d",charge);
            if(!Alert) {
                if(alertflag) {

                    //wait(2);
                    unsigned char x=j.alertResponse();
                    pc.printf("response %x \n",x);
                    x=j.getStatus();
                    pc.printf("status %x \n",x);


                }

            }
            jflag=0;

        }
    }
}