// LTC2944 V1.0
// 07/03/2017  GR :
#include "LTC2944.h"
//Serial pc(USBTX, USBRX);  // I/O terminal PC



LTC2944::LTC2944(PinName sda, PinName scl) : i2c(sda,scl),pc(USBTX, USBRX)
{
    address=0xC8;   // adresse I2C
    //i2c.frequency(400000);
}
void LTC2944::setRsense(float r)
{
    rsense=r;
}
//
void LTC2944::setMode(unsigned char m)
{
    dataw[0]=0x01;  // registre B control
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,1);    // lecture du registre
    pc.printf("valm1 %x \n",datar[0]);
    dataw[1]=(datar[0]&~0xC0)|(m<<6);
    i2c.write(address,dataw,2);  // ecriture
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,1);    // lecture du registre
    pc.printf("valm2 %x \n",datar[0]);
}
//
void LTC2944::setPrescaler(unsigned char p)
{
    dataw[0]=0x01;  // registre B control
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,1);    // lecture du registre
    pc.printf("valp1 %x \n",datar[0]);
    dataw[1]=(datar[0]&~0x38)|(p<<3);
    i2c.write(address,dataw,2);  // ecriture
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,1);    // lecture du registre
    pc.printf("valp2 %x \n",datar[0]);
}
//
void LTC2944::setImin(float imin)
{
    dataw[0]=0x12;  // registre B control
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre
    pc.printf("valImin1 %x %x \n",datar[0],datar[1]);
    short val=(short)((imin*rsense*32767/64)+32767);
    dataw[1]=(char)(val>>8);
    dataw[2]=(char)(val&0x00FF);
    i2c.write(address,dataw,3);  // ecriture
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre
    pc.printf("valmin2 %x %x \n",datar[0],datar[1]);
}

void LTC2944::setImax(float imin)
{
    dataw[0]=0x10;  // registre B control
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre
    pc.printf("valImax1 %x %x \n",datar[0],datar[1]);
    short val=(short)((imin*rsense*32767/64)+32767);
    dataw[1]=(char)(val>>8);
    dataw[2]=(char)(val&0x00FF);
    i2c.write(address,dataw,3);  // ecriture
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre
    pc.printf("valmax2 %x %x \n",datar[0],datar[1]);
}
//
float LTC2944::getVoltage(void)
{
    dataw[0]=8;  // adresse de la tension
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre de deux octets
    return((((unsigned short)(datar[0])<<8)+datar[1])*70.8/0xFFFF);
}

float LTC2944::getCurrent(void)
{
    dataw[0]=0xE;  // adresse de la tension
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre de deux octets
    unsigned short value=((unsigned short)(datar[0])<<8)|(unsigned short)datar[1];
    return(((float)(value)-32767.0)*64./rsense/32767.0);
}

unsigned short LTC2944::getAccumulatedCharge(void)
{
    dataw[0]=0x2;  // adresse de la tension
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,2);    // lecture du registre de deux octets
    return(((unsigned short)(datar[0])<<8)|(unsigned short)datar[1]);

}
unsigned char LTC2944::getStatus(void)
{
    dataw[0]=0x0;  // adresse status
    i2c.write(address,dataw,1,1);  // positionnement de l'adresse
    i2c.read(address,datar,1);    // lecture du registre de deux octets
    return(datar[0]);

}
unsigned char LTC2944::alertResponse(void)
{
    i2c.read(0x18,datar,1);    // lecture du registre de deux octets


    return( datar[0]);
}