#include "mbed.h"

Serial pc(USBTX, USBRX);
const int frequ = 50; //unit kHz
const char dev_addr = 0x00; //fixed
const char version[4] = "1.0";

void testmode(void);
void i2c_read(void);
void i2c_write(void);
void EasyFuse_prog(void);
void hot_read(void);
  
void clear_screen() {
    int i=0;
    pc.printf("\033[%dm", 36);//change text color to cyan
    pc.printf("\033[2J");//clears screen
    pc.printf("\033[%d;%dH%c", 1, 1);//locate cursor to the 0,0
    pc.printf("\n\r");    
    //Print CSI059
    pc.printf("\n\r     \332\304"); 
    for ( i = 0; i<46; i++) pc.printf("\304");
    pc.printf("\304\302");            
    pc.printf("\n\r     \263\t\t\t\t\t\t      \263");
    pc.printf("\n\r     \263   \334\334\334\t \334\334\334\t\334\334\334\t \334\334 \t\334\334\334\334\t \334\334   \263");
    pc.printf("\n\r     \263  \333    \t\333   \t \333 \t\333  \333\t\333   \t\333  \333  \263");
    pc.printf("\n\r     \263  \333    \t\337\337\334\334\t \333 \t\333  \333\t\337\337\337\334\t\337\334\334\333  \263");
    pc.printf("\n\r     \263  \333    \t   \333\t \333 \t\333  \333\t   \333\t   \333  \263");
    pc.printf("\n\r     \263   \337\337\337\t\337\337\337 \t\337\337\337\t \337\337 \t\337\337\337 \t\337\337\337   \263");
    pc.printf("\n\r     \263\t\t\t\t\t\t      \263\n\r     \300\304");
    for ( i = 0; i<46; i++) pc.printf("\304");
    pc.printf("\304\331");
    pc.printf("\n\n\n\r\tPROTYPE EVALUATION S/W");
    pc.printf("\n\n\r\tVersion : %s",version);
    pc.printf("\n\n\r   \315");   
    for ( i = 0; i<80; i++) pc.printf("\315"); 
    pc.printf("\n\n\n\r");
    pc.printf("\033[%dm", 32);//change text color to green    
}      

void print_menu() {
    int i=0;
    pc.printf("\n\n\r\tWhat do you want to do next ?");
    pc.printf("\033[%dm ", 31);//change text color to red
    pc.printf("\n\n\n\r\t\332\304"); 
    for ( i = 0; i<45; i++) pc.printf("\304");
    pc.printf("\304\302");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263");
    pc.printf("\n\r\t\263  Press 't' : to generate Test-Mode Sequence\t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263");
    pc.printf("\n\r\t\263  Press 'r' : to perform Register Read      \t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263");
    pc.printf("\n\r\t\263  Press 'w' : to perform Register Write     \t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263");
    pc.printf("\n\r\t\263  Press 'p' : to program Easy Fuse          \t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263");
    pc.printf("\n\r\t\263  Press 'h' : to Perform Hot Register Read  \t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263"); 
    pc.printf("\n\r\t\263  Press 'c' : to clear screen               \t\263");
    pc.printf("\n\r\t\263\t\t\t\t\t\t\263"); 
    pc.printf("\n\r\t\300\304");
    for ( i = 0; i<45; i++) pc.printf("\304");
    pc.printf("\304\331");
    pc.printf("\033[%dm", 32);//change text color to green                
    pc.printf("\n\n\n\r\tYour Selection : ");
}         

void draw_line() {
    pc.printf("\033[%dm ", 33);//change text color to yellow
    pc.printf("\n\n\n\n\r   \315");   
    for ( int i = 0; i<80; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green
    pc.printf("\n\n\r");
}    

void draw_bar() {
    pc.printf("\033[%dm ", 33);//change text color to yellow
    pc.printf("\n\n\n\n\r   \334");   
    for ( int i = 0; i<80; i++) pc.printf("\334");
    pc.printf("\033[%dm ", 32);//change text color to green
    pc.printf("\n\n\r");
}               

void clear_screen_ques() {
    int temp;
    pc.printf("\n\n\r\tClear Screen (y/n) : ");  
    temp = 0;
    while ( temp!='y' && temp!='n') {
        temp = pc.getc();
    }
    if (temp == 'y') clear_screen();
    else draw_bar();
}
                            
char get_selection() {
    char current_char;
    int flag = 0;
    while (flag == 0) {
        current_char = pc.getc();
        if ( current_char == 't' || current_char == 'r' || current_char == 'w' || current_char == 'p' || current_char == 'c' || current_char == 'h' ) flag = 1;
        else {
            pc.printf(" \033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40); 
            pc.printf("\n\n\r\tYour Selection : "); 
        }
    }
    return current_char;
}   
    
void print_note() {
    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\r\tNote : ");
    pc.printf("\n\r\t\304\304\304\304\304\304");
    pc.printf("\n\n\r\t1. In Tera Term, enable 'Local echo' in Setup -> Terminal");
    pc.printf("\n\n\r\t2. When not specified, please do not press 'enter' key after typing any entry ");
    pc.printf("\033[%dm", 32);//change text color to green
    draw_line();
}  

int main() {
    char current_char=0;  
    clear_screen();
    print_note();
    while(1) {
        print_menu();
        current_char = get_selection();
        draw_line();
        
        switch (current_char) {
            
            case 't':
                testmode();
                clear_screen_ques();
                break;
                
            case 'r':
                i2c_read();
                clear_screen_ques();
                break;
                                
            case 'w':
                i2c_write();
                clear_screen_ques();
                break; 
                
            case 'p':
                EasyFuse_prog();
                clear_screen_ques();
                break;
                
            case 'h':
                hot_read();
                clear_screen_ques();
                break;
                                
            case 'c':
                clear_screen();
                break;                                                           
        
        }      
    }//end of while     
}