#include "mbed.h"

extern Serial pc;


char test_char = 0;
int test = 1;

void get_char() {
    test_char = pc.getc();
    if(test_char == 's') test=0;
    pc.printf("\n\r"); 
}  

void testmode() {
    DigitalOut sda(p9,1);
    DigitalOut scl(p10,1);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    Timer timer1;
    test = 1; 
    test_char = 0;
    pc.printf("\n\n\r\tStarting test-mode pattern generation ...\n\r");
    pc.printf("\n\n\r\tEnter 's' to stop test-mode: ");
    pc.attach(&get_char); //interupt looking for character entry    
    timer1.start();
    while(test) {
        while(timer1.read_us()<300) {
        }
        sda=0;
        while(timer1.read_us()<600) {
        }
        scl=0;
        while(timer1.read_us()<900) {
        }               
        sda=1;
        while(timer1.read_us()<950) {
        } 
        scl=1;
        while(timer1.read_us()<1200) {
        }
        timer1.reset();             
    }
    timer1.stop();
    scl=1;
    sda=1;
    pc.printf("\n\n\r\t....test-mode pattern generation stopped\n\n\r");
    sda.~DigitalOut();
    scl.~DigitalOut();
    pc.attach(NULL);
    return; 
}    